/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.ping.util;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public interface ByteBufCodecUtils {
    public static final StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        public void encode(ByteBuf byteBuf, Vec3 vec3) {
            byteBuf.writeDouble(vec3.x());
            byteBuf.writeDouble(vec3.y());
            byteBuf.writeDouble(vec3.z());
        }

        public Vec3 decode(ByteBuf byteBuf) {
            return new Vec3(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
        }
    };

    public static <T extends Enum<T>> StreamCodec<ByteBuf, T> enumCodec(final Class<T> clazz) {
        return new StreamCodec<ByteBuf, T>(){

            public void encode(ByteBuf byteBuf, T t) {
                byteBuf.writeInt(((Enum)t).ordinal());
            }

            public T decode(ByteBuf byteBuf) {
                return ((Enum[])clazz.getEnumConstants())[byteBuf.readInt()];
            }
        };
    }
}

