/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.ping.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HitUtil {
    public static HitResult pick(Entity entity, double interactionRange) {
        AABB aabb;
        double d1 = Mth.square((double)interactionRange);
        Vec3 vec3 = entity.getEyePosition(1.0f);
        HitResult hitresult = entity.pick(interactionRange, 1.0f, false);
        double d2 = hitresult.getLocation().distanceToSqr(vec3);
        if (hitresult.getType() != HitResult.Type.MISS) {
            d1 = d2;
            interactionRange = Math.sqrt(d2);
        }
        Vec3 vec31 = entity.getViewVector(1.0f);
        Vec3 vec32 = vec3.add(vec31.x * interactionRange, vec31.y * interactionRange, vec31.z * interactionRange);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)vec3, (Vec3)vec32, (AABB)(aabb = entity.getBoundingBox().expandTowards(vec31.scale(interactionRange)).inflate(1.0, 1.0, 1.0)), p_234237_ -> !p_234237_.isSpectator() && p_234237_.isPickable(), (double)d1);
        return entityhitresult != null && entityhitresult.getLocation().distanceToSqr(vec3) < d2 ? HitUtil.filterHitResult((HitResult)entityhitresult, vec3, interactionRange) : HitUtil.filterHitResult(hitresult, vec3, interactionRange);
    }

    private static HitResult filterHitResult(HitResult hitResult, Vec3 pos, double blockInteractionRange) {
        Vec3 vec3 = hitResult.getLocation();
        if (!vec3.closerThan((Position)pos, blockInteractionRange)) {
            Vec3 vec31 = hitResult.getLocation();
            Direction direction = Direction.getNearest((double)(vec31.x - pos.x), (double)(vec31.y - pos.y), (double)(vec31.z - pos.z));
            return BlockHitResult.miss((Vec3)vec31, (Direction)direction, (BlockPos)BlockPos.containing((Position)vec31));
        }
        return hitResult;
    }
}

