/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
package org.windclan.embeddedcomputer.embedded.block;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import org.windclan.embeddedcomputer.embedded.item.ComputerBlockItem;
import org.windclan.embeddedcomputer.registry;

import static java.util.Objects.isNull;

public class EmbeddedComputerBlock<T extends EmbeddedComputerBlockEntity> extends class_2383  implements class_2343 {
    public static class_2754 powered = ComputerBlock.STATE;

    public EmbeddedComputerBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043).method_11657(powered,ComputerState.OFF));
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return method_54094(EmbeddedComputerBlock::new);
    }

    private final class_5558<T> ticker = (level, pos, state, computer) -> computer.serverTick();
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12481,powered);
    }
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new EmbeddedComputerBlockEntity(pos,state);
    }
    // update for peripherals
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        var comp1 = world.method_8321(pos);
        if (!isNull(comp1) && comp1 instanceof EmbeddedComputerBlockEntity) {
            var comp = (EmbeddedComputerBlockEntity) comp1;
            comp.neighborChanged(pos);
        }
    }
    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        var comp1 = world.method_8321(pos);
        if (!isNull(comp1) && comp1 instanceof EmbeddedComputerBlockEntity) {
            var comp = (EmbeddedComputerBlockEntity) comp1;
            comp.updateInputsImmediately();
        }
    }

    //turn on computer
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        var blockEntity1 = world.method_8321(pos);
        if (!world.method_8608() && !isNull(blockEntity1)) {
            var blockEntity = (EmbeddedComputerBlockEntity) blockEntity1;
            var computer = blockEntity.getServerComputer();
            if (isNull(computer)) {
                computer = blockEntity.createServerComputer();
                computer.turnOn();
            }
            else {
                computer.reboot();
            }
        }
        return class_1269.method_29236(true);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return super.method_9605(ctx).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }
    @Override
    public class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591 type) {
        return world.field_9236 ? null : BlockEntityHelpers.createTickerHelper(type, (class_2591) registry.EMBEDDED_COMPUTER_ENTITY, ticker);
    }
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        var id = -1;
        var comp1 = world.method_8321(pos);
        if (!isNull(comp1)) {
            id = ((EmbeddedComputerBlockEntity) comp1).getComputerID();
        }
        return ((ComputerBlockItem)registry.EMBEDDED_COMPUTER_ITEM).newComputerItem(id);
    }

    public class_1792 method_8389() {
        return registry.EMBEDDED_COMPUTER_ITEM;
    }

}
