/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
package org.windclan.embeddedcomputer.embedded.item;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.util.NonNegativeId;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public class ComputerBlockItem extends class_1747 {
    public ComputerBlockItem(class_2248 block) {
        super(block, new class_1792.class_1793().method_24359());
    }
    public class_1799 newComputerItem(int id) {
        var stack = new class_1799(this);
        if (id > 0) stack.method_57379(ModRegistry.DataComponents.COMPUTER_ID.get(),NonNegativeId.of(id));
        return stack;
    }
    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        NonNegativeId computerId = stack.method_57824(ModRegistry.DataComponents.COMPUTER_ID.get());
        if (computerId == null) return;
        if (computerId.id() < 0) return;
        tooltip.add(class_2561.method_43470("Computer: "+computerId.id()).method_27692(class_124.field_1063));
    }
}
