/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
package org.windclan.embeddedcomputer;

import com.mojang.serialization.Codec;
import dan200.computercraft.api.component.ComputerComponent;
import dan200.computercraft.api.peripheral.PeripheralLookup;
import org.windclan.embeddedcomputer.embedded.EmbeddedComputerPeripheral;
import org.windclan.embeddedcomputer.embedded.IEmbeddedComputer;
import org.windclan.embeddedcomputer.embedded.block.EmbeddedComputerBlock;
import org.windclan.embeddedcomputer.embedded.block.EmbeddedComputerBlockEntity;
import org.windclan.embeddedcomputer.embedded.item.ComputerBlockItem;
import org.windclan.embeddedcomputer.storage.harddrive.HardDriveBlock;
import org.windclan.embeddedcomputer.storage.harddrive.HardDriveBlockEntity;
import org.windclan.embeddedcomputer.platform.registry1;
import org.windclan.embeddedcomputer.storage.harddrive.HardDriveItem;
import org.windclan.embeddedcomputer.storage.harddrive.HardDrivePeripheral;
import org.windclan.embeddedcomputer.storage.items.DebugMediaItem;
import org.windclan.embeddedcomputer.storage.items.FlashCardItem;
import org.windclan.embeddedcomputer.storage.items.ZipDiskItem;

import java.util.function.UnaryOperator;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9331;

public class registry {
    public static class_2248 EMBEDDED_COMPUTER = class_2378.method_10230(
            class_7923.field_41175,
            class_2960.method_60655("embeddedcomputer","embedded_computer"),
            new EmbeddedComputerBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15975).method_51369())
    );
    public static class_2591<EmbeddedComputerBlockEntity> EMBEDDED_COMPUTER_ENTITY = class_2378.method_10230(
            class_7923.field_41181,
            class_2960.method_60655("embeddedcomputer", "embedded_computer_entity"),
            class_2591.class_2592.method_20528(EmbeddedComputerBlockEntity::new, EMBEDDED_COMPUTER).method_11034(null)
    );
    public static class_1792 EMBEDDED_COMPUTER_ITEM = class_2378.method_10230(
            class_7923.field_41178,
            class_2960.method_60655("embeddedcomputer", "embedded_computer"),
            new ComputerBlockItem(EMBEDDED_COMPUTER)
    );

    public static final class_2248 HARD_DRIVE = class_2378.method_10230(
            class_7923.field_41175,
            class_2960.method_60655("embeddedcomputer","hard_drive"),
            new HardDriveBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15975).method_51369())
    );
    public static final class_2591 HARD_DRIVE_ENTITY = class_2378.method_10230(class_7923.field_41181,class_2960.method_43902("embeddedcomputer","hard_drive_entity"), class_2591.class_2592.method_20528(HardDriveBlockEntity::new,HARD_DRIVE).method_11034(null));
    public static class_1792 HARD_DRIVE_ITEM = class_2378.method_10230(
            class_7923.field_41178,
            class_2960.method_60655("embeddedcomputer", "hard_drive"),
            new HardDriveItem(HARD_DRIVE, new class_1792.class_1793().method_7889(1))
    );

    public static final class_1792 DEBUG_MEDIA_ITEM = class_2378.method_10230(class_7923.field_41178, class_2960.method_43902("embeddedcomputer", "debug_rock"), new DebugMediaItem(new class_1792.class_1793()));
    public static final class_1792 ZIP_DISK_ITEM = class_2378.method_10230(class_7923.field_41178, class_2960.method_43902("embeddedcomputer", "zip_disk"), new ZipDiskItem(new class_1792.class_1793()));
    public static final class_1792 FLASH_CARD_ITEM = class_2378.method_10230(class_7923.field_41178, class_2960.method_43902("embeddedcomputer", "flash_card"), new FlashCardItem(new class_1792.class_1793()));

    public static final ComputerComponent<IEmbeddedComputer> EMBEDDED_COMPONENT = ComputerComponent.create("embeddedcomputer","embedded_computer");


    public static final class_9331<Integer> id = register("id", builder -> builder
            .method_57881(Codec.INT)
            .method_57882(class_9135.field_49675));

    public static final class_9331<String> uuid = register("uuid", builder -> builder
            .method_57881(Codec.STRING)
            .method_57882(class_9135.field_48554));

    public static <T> class_9331<T> register(String path, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(class_7923.field_49658, class_2960.method_60655("embeddedcomputer", path), builderOperator.apply(class_9331.method_57873()).method_57880());
    }

    public void registerPeripherals() {
        PeripheralLookup.get().registerForBlockEntities(EmbeddedComputerPeripheral::getPeripheral,EMBEDDED_COMPUTER_ENTITY);
        PeripheralLookup.get().registerForBlockEntities(HardDrivePeripheral::getPeripheral,HARD_DRIVE_ENTITY);
    }
    public void registerItemGroups() {
        var a = new registry1();
        a.registerItemGroups();
    }
}
