/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
package org.windclan.embeddedcomputer.storage;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.integration.FabricPermissionRegistry;
import org.jetbrains.annotations.Nullable;
import org.windclan.embeddedcomputer.registry;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9334;

public abstract class MediaItem extends class_1792 implements IMedia {
    public MediaItem(class_1793 settings) {
        super(settings);
    }
    private static final String nbtId = "id";
    public void setId(class_1799 stack,int diskId1) {
        stack.method_57379(registry.id,diskId1);
    }
    public int getId(class_1799 stack) {
        Integer diskId = stack.method_57824(registry.id);
        if (diskId == null) return -1;
        return diskId;
    }

    public abstract int getMaxStorage();

    public abstract String getMountName();

    @Nullable
    @Override
    public String getLabel(class_7225.class_7874 a, class_1799 stack) {
        if (stack.method_57824(class_9334.field_49631) != null) return stack.method_57824(class_9334.field_49631).getString();
        else return null;
    }

    @Override
    public boolean setLabel(class_1799 stack, @Nullable String label) {
        if (label != null) stack.method_57379(class_9334.field_49631,class_2561.method_30163(label));
        else stack.method_57379(class_9334.field_49631,null);
        return true;
    }

    @Nullable
    @Override
    public WritableMount createDataMount(class_1799 stack, class_3218 world) {
        var diskID = getId(stack);
        if (diskID < 0) {
            diskID = ComputerCraftAPI.createUniqueNumberedSaveDir(world.method_8503(), getMountName());
            setId(stack, diskID);
        }
        return ComputerCraftAPI.createSaveDirMount(world.method_8503(), getMountName()+"/" + diskID, getMaxStorage());
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        var id = getId(stack);
        if (id >= 0) {
            tooltip.add(class_2561.method_43470("Id: "+id)
                    .method_27692(class_124.field_1080));
        }
    }
}