/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
package org.windclan.embeddedcomputer.storage.harddrive;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import net.minecraft.block.*;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

import java.util.List;

import static org.windclan.embeddedcomputer.registry.HARD_DRIVE_ENTITY;

public class HardDriveBlock extends class_2237 implements class_2343 {
    public HardDriveBlock(class_2251 settings) {
        super(settings);
        method_9590(method_9564().method_11657(class_2741.field_12481, class_2350.field_11043));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12481);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new HardDriveBlockEntity(pos,state);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return super.method_9605(ctx).method_11657(class_2741.field_12481, ctx.method_8042().method_10153());
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, HARD_DRIVE_ENTITY, (world1, pos, state1, be) -> HardDriveBlockEntity.tick(world1, pos, state1, be));
    }
}