/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */
package org.windclan.embeddedcomputer.storage.harddrive;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import org.windclan.embeddedcomputer.registry;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_9323;

import static java.util.Objects.isNull;

public class HardDriveBlockEntity extends class_2586  {
    public HardDriveBlockEntity(class_2338 pos, class_2680 state) {
        super(registry.HARD_DRIVE_ENTITY,pos, state);
    }
    private final HardDrivePeripheral periph = new HardDrivePeripheral(this);
    public String uuid = "";
    public String mount;

    public static void tick(class_1937 world1, class_2338 pos, class_2680 state1, class_2586 be) {}
    public WritableMount makeMount() {
        if (uuid.isEmpty()) {
            uuid = UUID.randomUUID().toString();
            method_5431();
        }
        return ComputerCraftAPI.createSaveDirMount(field_11863.method_8503(), "hdd/" + uuid, 25000000); // 25 Megabytes
    }
    public boolean attach(IComputerAccess computer, @Nullable String str) {
        if (isNull(str)) {
            str = "drive";
        }
        mount = computer.mountWritable(str,makeMount());
        return !isNull(mount);
    }
    public boolean detach(IComputerAccess computer, @Nullable String str) {
        if (isNull(str)) {
            str = "drive";
        }
        try {
            computer.unmount(str);
            return true;
        } catch(Exception ignored) {
            return false;
        }
    }
    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("uuid", uuid);
        super.method_11007(nbt,registryLookup);
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt,registryLookup);
        uuid = nbt.method_10558("uuid");
        if (uuid.isEmpty()) {
            uuid = UUID.randomUUID().toString();
            method_5431();
        }
    }

    @Override
    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        uuid = components.method_58695(registry.uuid,"");
        if (uuid.isEmpty()) {
            uuid = UUID.randomUUID().toString();
            method_5431();
        }
    }

    @Override
    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(registry.uuid,this.uuid);
    }

    @Override
    public void method_57569(class_2487 nbt) {
        nbt.method_10551("uuid");
    }
    public IPeripheral peripheral() {
        return periph;
    }


}
