/*
 * Decompiled with CFR 0.152.
 */
package net.mattias.capybara.core.entity.custom;

import java.util.UUID;
import net.mattias.capybara.core.block.ModBlocks;
import net.mattias.capybara.core.entity.ModEntities;
import net.mattias.capybara.core.entity.custom.goals.UntamedTemptGoal;
import net.mattias.capybara.core.gui.inventory.CapybaraInventoryMenu;
import net.mattias.capybara.core.item.ModItems;
import net.mattias.capybara.core.sound.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CapybaraEntity
extends TamableAnimal
implements ContainerListener {
    private static final EntityDataAccessor<Integer> FUR_COLOR = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ARMOR_VARIANT = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_SHEARED = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SITTING = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_TOP_HAT = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHEF_HAT = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SUPERMAN_CAPE = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_WITCH_HAT = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CROWN = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PIRATE_HAT = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PLUNGER_HEAD = SynchedEntityData.m_135353_(CapybaraEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final SimpleContainer capybaraInventory = new SimpleContainer(3);
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int sitStillTicks = 0;
    private int regrowthTime = 0;

    public CapybaraEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.m_7105_(false);
        this.capybaraInventory.m_19164_((ContainerListener)this);
    }

    public boolean hasTopHatEquipped() {
        ItemStack cosmeticSlot = this.capybaraInventory.m_8020_(0);
        return cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_TOP_HAT.get());
    }

    public boolean hasChefHatEquipped() {
        ItemStack cosmeticSlot = this.capybaraInventory.m_8020_(0);
        return cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_CHEF_HAT.get());
    }

    public boolean hasWitchHatEquipped() {
        ItemStack cosmeticSlot = this.capybaraInventory.m_8020_(0);
        return cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_WITCH_HAT.get());
    }

    public boolean hasCrownEquipped() {
        ItemStack cosmeticSlot = this.capybaraInventory.m_8020_(0);
        return cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_CROWN.get());
    }

    public boolean hasPirateHatEquipped() {
        ItemStack cosmeticSlot = this.capybaraInventory.m_8020_(0);
        return cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_PIRATE_HAT.get());
    }

    public boolean hasPlungerHeadEquipped() {
        ItemStack cosmeticSlot = this.capybaraInventory.m_8020_(0);
        return cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_PLUNGER_HEAD.get());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.isSitting()) {
            ++this.sitStillTicks;
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            this.m_21310_(Integer.MAX_VALUE);
            if (!(this.m_20096_() || this.m_20069_() || this.m_20159_())) {
                this.m_20334_(this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
            } else {
                this.m_20334_(0.0, 0.0, 0.0);
            }
        } else {
            this.sitStillTicks = 0;
        }
        if (!this.m_9236_().m_5776_() && this.isSheared()) {
            this.regrowthTime = Math.max(0, this.regrowthTime - 1);
            if (this.regrowthTime == 0) {
                this.setSheared(false);
            }
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FUR_COLOR, (Object)1);
        this.f_19804_.m_135372_(ARMOR_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_SHEARED, (Object)false);
        this.f_19804_.m_135372_(DATA_SITTING, (Object)false);
        this.f_19804_.m_135372_(DATA_TOP_HAT, (Object)false);
        this.f_19804_.m_135372_(DATA_CHEF_HAT, (Object)false);
        this.f_19804_.m_135372_(DATA_WITCH_HAT, (Object)false);
        this.f_19804_.m_135372_(DATA_CROWN, (Object)false);
        this.f_19804_.m_135372_(DATA_PIRATE_HAT, (Object)false);
        this.f_19804_.m_135372_(DATA_PLUNGER_HEAD, (Object)false);
        this.f_19804_.m_135372_(DATA_SUPERMAN_CAPE, (Object)false);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(DATA_SHEARED, (Object)sheared);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(2, (Goal)new UntamedTemptGoal(this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    public SimpleContainer getInventory() {
        return this.capybaraInventory;
    }

    public void m_5757_(Container container) {
        if (container == this.capybaraInventory) {
            ItemStack cosmetic;
            ItemStack armor = this.capybaraInventory.m_8020_(1);
            if (armor.m_150930_((Item)ModItems.CAPYBARA_IRON_ARMOR.get())) {
                this.setArmorVariant(1);
                if (this.m_21051_(Attributes.f_22284_) != null) {
                    this.m_21051_(Attributes.f_22284_).m_22100_(3.0);
                }
            } else if (armor.m_150930_((Item)ModItems.CAPYBARA_GOLD_ARMOR.get())) {
                this.setArmorVariant(2);
                if (this.m_21051_(Attributes.f_22284_) != null) {
                    this.m_21051_(Attributes.f_22284_).m_22100_(2.0);
                }
            } else if (armor.m_150930_((Item)ModItems.CAPYBARA_DIAMOND_ARMOR.get())) {
                this.setArmorVariant(3);
                if (this.m_21051_(Attributes.f_22284_) != null) {
                    this.m_21051_(Attributes.f_22284_).m_22100_(5.0);
                }
            } else {
                this.setArmorVariant(0);
                if (this.m_21051_(Attributes.f_22284_) != null) {
                    this.m_21051_(Attributes.f_22284_).m_22100_(0.0);
                }
            }
            if ((cosmetic = this.capybaraInventory.m_8020_(0)).m_150930_((Item)ModItems.CAPYBARA_TOP_HAT.get())) {
                this.setTopHat(true);
            } else {
                this.setTopHat(false);
            }
            if (cosmetic.m_150930_((Item)ModItems.CAPYBARA_CHEF_HAT.get())) {
                this.setChefHat(true);
            } else {
                this.setChefHat(false);
            }
            if (cosmetic.m_150930_((Item)ModItems.CAPYBARA_WITCH_HAT.get())) {
                this.setWitchHat(true);
            } else {
                this.setWitchHat(false);
            }
            if (cosmetic.m_150930_((Item)ModItems.CAPYBARA_CROWN.get())) {
                this.setCrown(true);
            } else {
                this.setCrown(false);
            }
            if (cosmetic.m_150930_((Item)ModItems.CAPYBARA_PIRATE_HAT.get())) {
                this.setPirateHat(true);
            } else {
                this.setPirateHat(false);
            }
            if (cosmetic.m_150930_((Item)ModItems.CAPYBARA_PLUNGER_HEAD.get())) {
                this.setPlungerHead(true);
            } else {
                this.setPlungerHead(false);
            }
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel lvl, AgeableMob parent) {
        CapybaraEntity baby = (CapybaraEntity)((EntityType)ModEntities.CAPYBARA.get()).m_20615_((Level)lvl);
        if (baby != null) {
            CapybaraEntity other = (CapybaraEntity)parent;
            baby.setFurColor(this.f_19796_.m_188499_() ? this.getFurColor() : other.getFurColor());
            baby.setArmorVariant(0);
            baby.setSheared(false);
            baby.setTopHat(false);
            baby.setChefHat(false);
            baby.setWitchHat(false);
            baby.setCrown(false);
            baby.setPirateHat(false);
            baby.setPlungerHead(false);
            baby.setSupermanCape(false);
            UUID owner = this.m_21805_();
            if (owner != null) {
                baby.m_21816_(owner);
                baby.m_7105_(true);
            }
        }
        return baby;
    }

    public int getFurColor() {
        return (Integer)this.f_19804_.m_135370_(FUR_COLOR);
    }

    public void setFurColor(int color) {
        this.f_19804_.m_135381_(FUR_COLOR, (Object)color);
    }

    public int getArmorVariant() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_VARIANT);
    }

    public void setArmorVariant(int variant) {
        this.f_19804_.m_135381_(ARMOR_VARIANT, (Object)variant);
    }

    public boolean hasTopHat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TOP_HAT);
    }

    public void setTopHat(boolean hasTopHat) {
        this.f_19804_.m_135381_(DATA_TOP_HAT, (Object)hasTopHat);
    }

    public boolean hasChefHat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHEF_HAT);
    }

    public void setChefHat(boolean hasChefHat) {
        this.f_19804_.m_135381_(DATA_CHEF_HAT, (Object)hasChefHat);
    }

    public boolean hasWitchHat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WITCH_HAT);
    }

    public void setWitchHat(boolean hasWitchHat) {
        this.f_19804_.m_135381_(DATA_WITCH_HAT, (Object)hasWitchHat);
    }

    public boolean hasCrown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CROWN);
    }

    public void setCrown(boolean hasCrown) {
        this.f_19804_.m_135381_(DATA_CROWN, (Object)hasCrown);
    }

    public boolean hasPirateHat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PIRATE_HAT);
    }

    public void setPirateHat(boolean hasPirateHat) {
        this.f_19804_.m_135381_(DATA_PIRATE_HAT, (Object)hasPirateHat);
    }

    public boolean hasPlungerHead() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLUNGER_HEAD);
    }

    public void setPlungerHead(boolean hasPlungerHead) {
        this.f_19804_.m_135381_(DATA_PLUNGER_HEAD, (Object)hasPlungerHead);
    }

    public boolean hasSupermanCape() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SUPERMAN_CAPE);
    }

    public void setSupermanCape(boolean hasSupermanCape) {
        this.f_19804_.m_135381_(DATA_SUPERMAN_CAPE, (Object)hasSupermanCape);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor lvl, DifficultyInstance diff, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        super.m_6518_(lvl, diff, reason, data, tag);
        int furColorMax = 10;
        if (tag != null && tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
            if (this.isSheared() && tag.m_128441_("RegrowthTime")) {
                this.regrowthTime = tag.m_128451_("RegrowthTime");
            }
        }
        if (tag != null && tag.m_128441_("FurColor")) {
            this.setFurColor(tag.m_128451_("FurColor"));
        } else {
            this.setFurColor(this.f_19796_.m_188503_(furColorMax) + 1);
        }
        if (tag != null && tag.m_128441_("TopHat")) {
            this.setTopHat(tag.m_128471_("TopHat"));
        }
        if (tag != null && tag.m_128441_("ChefHat")) {
            this.setChefHat(tag.m_128471_("ChefHat"));
        }
        if (tag != null && tag.m_128441_("WitchHat")) {
            this.setWitchHat(tag.m_128471_("WitchHat"));
        }
        if (tag != null && tag.m_128441_("Crown")) {
            this.setCrown(tag.m_128471_("Crown"));
        }
        if (tag != null && tag.m_128441_("PirateHat")) {
            this.setPirateHat(tag.m_128471_("PirateHat"));
        }
        if (tag != null && tag.m_128441_("PlungerHead")) {
            this.setPlungerHead(tag.m_128471_("PlungerHead"));
        }
        if (this.m_6162_()) {
            this.m_146762_(-48000);
        }
        return data;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("FurColor", this.getFurColor());
        tag.m_128379_("Sheared", this.isSheared());
        if (this.isSheared()) {
            tag.m_128405_("RegrowthTime", this.regrowthTime);
        }
        tag.m_128405_("ArmorVariant", this.getArmorVariant());
        tag.m_128379_("isSitting", this.isSitting());
        tag.m_128379_("TopHat", this.hasTopHat());
        tag.m_128379_("ChefHat", this.hasChefHat());
        tag.m_128379_("WitchHat", this.hasWitchHat());
        tag.m_128379_("Crown", this.hasCrown());
        tag.m_128379_("PirateHat", this.hasPirateHat());
        tag.m_128379_("PlungerHead", this.hasPlungerHead());
        CompoundTag inventoryTag = new CompoundTag();
        for (int i = 0; i < this.capybaraInventory.m_6643_(); ++i) {
            ItemStack stack = this.capybaraInventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            inventoryTag.m_128365_("Slot" + i, (Tag)itemTag);
        }
        tag.m_128365_("CapybaraInventory", (Tag)inventoryTag);
    }

    public void m_7378_(CompoundTag tag) {
        ItemStack cosmeticSlot;
        super.m_7378_(tag);
        this.setFurColor(tag.m_128451_("FurColor"));
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
            if (this.isSheared() && tag.m_128441_("RegrowthTime")) {
                this.regrowthTime = tag.m_128451_("RegrowthTime");
            }
        }
        if (this.m_6162_() && this.isSheared()) {
            this.setSheared(false);
            this.regrowthTime = 0;
        }
        if (tag.m_128441_("ArmorVariant")) {
            this.setArmorVariant(tag.m_128451_("ArmorVariant"));
        }
        this.setSitting(tag.m_128471_("isSitting"));
        if (tag.m_128441_("CapybaraInventory")) {
            CompoundTag inventoryTag = tag.m_128469_("CapybaraInventory");
            for (int i = 0; i < this.capybaraInventory.m_6643_(); ++i) {
                if (inventoryTag.m_128441_("Slot" + i)) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("Slot" + i));
                    this.capybaraInventory.m_6836_(i, stack);
                    continue;
                }
                this.capybaraInventory.m_6836_(i, ItemStack.f_41583_);
            }
        }
        if ((cosmeticSlot = this.capybaraInventory.m_8020_(0)).m_150930_((Item)ModItems.CAPYBARA_TOP_HAT.get())) {
            this.setTopHat(true);
        } else {
            if (tag.m_128441_("TopHat")) {
                this.setTopHat(tag.m_128471_("TopHat"));
            } else {
                this.setTopHat(false);
            }
            if (cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_CHEF_HAT.get())) {
                this.setChefHat(true);
            }
            if (tag.m_128441_("ChefHat")) {
                this.setChefHat(tag.m_128471_("ChefHat"));
            } else {
                this.setChefHat(false);
            }
            if (cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_WITCH_HAT.get())) {
                this.setWitchHat(true);
            }
            if (tag.m_128441_("WitchHat")) {
                this.setWitchHat(tag.m_128471_("WitchHat"));
            } else {
                this.setWitchHat(false);
            }
            if (cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_CROWN.get())) {
                this.setCrown(true);
            }
            if (tag.m_128441_("Crown")) {
                this.setCrown(tag.m_128471_("Crown"));
            } else {
                this.setCrown(false);
            }
            if (cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_PIRATE_HAT.get())) {
                this.setPirateHat(true);
            }
            if (tag.m_128441_("PirateHat")) {
                this.setPirateHat(tag.m_128471_("PirateHat"));
            } else {
                this.setPirateHat(false);
            }
            if (cosmeticSlot.m_150930_((Item)ModItems.CAPYBARA_PLUNGER_HEAD.get())) {
                this.setPlungerHead(true);
            }
            if (tag.m_128441_("PlungerHead")) {
                this.setPlungerHead(tag.m_128471_("PlungerHead"));
            } else {
                this.setPlungerHead(false);
            }
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        for (int i = 0; i < this.capybaraInventory.m_6643_(); ++i) {
            ItemStack stack = this.capybaraInventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.m_19983_(stack);
        }
        if (!this.isSheared()) {
            int furDropCount = 1 + this.f_19796_.m_188503_(2) + looting;
            for (int i = 0; i < furDropCount; ++i) {
                ItemStack furDrop = this.getFurDropForColor(this.getFurColor());
                if (furDrop.m_41619_()) continue;
                this.m_19983_(furDrop);
            }
        }
        int muttonDropCount = 1 + this.f_19796_.m_188503_(2);
        for (int i = 0; i < muttonDropCount; ++i) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42658_));
        }
    }

    private ItemStack getFurDropForColor(int furColor) {
        return switch (furColor) {
            case 1 -> new ItemStack((ItemLike)ModBlocks.CAPYBARA_FUR_BLOCK.get());
            case 2 -> new ItemStack((ItemLike)ModBlocks.LIGHT_GRAY_CAPYBARA_FUR_BLOCK.get());
            case 3 -> new ItemStack((ItemLike)ModBlocks.GRAY_CAPYBARA_FUR_BLOCK.get());
            case 4 -> new ItemStack((ItemLike)ModBlocks.CREAM_CAPYBARA_FUR_BLOCK.get());
            case 5 -> new ItemStack((ItemLike)ModBlocks.WHITE_CAPYBARA_FUR_BLOCK.get());
            case 6 -> new ItemStack((ItemLike)ModBlocks.RED_CAPYBARA_FUR_BLOCK.get());
            case 7 -> new ItemStack((ItemLike)ModBlocks.DARK_BROWN_CAPYBARA_FUR_BLOCK.get());
            case 8 -> new ItemStack((ItemLike)ModBlocks.LIGHT_BROWN_CAPYBARA_FUR_BLOCK.get());
            case 9 -> new ItemStack((ItemLike)ModBlocks.GOLD_CAPYBARA_FUR_BLOCK.get());
            case 10 -> new ItemStack((ItemLike)ModBlocks.BLACK_CAPYBARA_FUR_BLOCK.get());
            default -> new ItemStack((ItemLike)ModBlocks.CAPYBARA_FUR_BLOCK.get());
        };
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_41867_);
    }

    protected SoundEvent m_7515_() {
        return this.f_19796_.m_188501_() < 0.5f ? (SoundEvent)ModSounds.CAPYBARA_AMBIENT.get() : (SoundEvent)ModSounds.CAPYBARA_AMBIENT_2.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.CAPYBARA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CAPYBARA_DEATH.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_(Items.f_41909_) && !this.m_21824_() || itemstack.m_150930_(Items.f_41867_);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (itemstack.m_150930_(Items.f_41909_)) {
            if (this.m_21824_()) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(2.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11912_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_21824_()) {
            if (itemstack.m_150930_(Items.f_41867_) && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && this.m_21830_((LivingEntity)player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new CapybaraInventoryMenu(windowId, playerInventory, this), this.m_5446_()), buf -> buf.m_130130_(this.m_19879_()));
                }
                return InteractionResult.SUCCESS;
            }
            InteractionResult interaction = super.m_6071_(player, hand);
            if ((!interaction.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interaction;
        }
        if (itemstack.m_150930_(Items.f_42574_) && !this.isSheared() && !this.m_6162_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
            int dropCount = 2 + this.f_19796_.m_188503_(2);
            ItemStack furDrop = this.getFurDropForColor(this.getFurColor());
            for (int i = 0; i < dropCount; ++i) {
                this.m_19983_(furDrop.m_41777_());
            }
            itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            this.setSheared(true);
            this.regrowthTime = 6000;
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource p_30386_, float p_30387_) {
        if (this.m_6673_(p_30386_)) {
            return false;
        }
        Entity entity = p_30386_.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.m_6469_(p_30386_, p_30387_);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(20.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(8.0);
        }
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SITTING);
    }

    public void setSitting(boolean sitting) {
        this.f_19804_.m_135381_(DATA_SITTING, (Object)sitting);
        this.m_21839_(sitting);
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SITTING);
    }

    public void m_21839_(boolean sitting) {
        this.f_19804_.m_135381_(DATA_SITTING, (Object)sitting);
    }
}

