/*
 * Decompiled with CFR 0.152.
 */
package com.dulkirfabric.features;

import com.dulkirfabric.config.DulkirConfig;
import com.dulkirfabric.events.PlaySoundEvent;
import com.dulkirfabric.events.WorldLoadEvent;
import com.dulkirfabric.util.SoundInfo;
import com.dulkirfabric.util.TrackedCooldown;
import com.dulkirfabric.util.Utils;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00150\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/dulkirfabric/features/CooldownDisplays;", "", "<init>", "()V", "Lnet/minecraft/class_1799;", "stack", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "", "cir", "", "shouldDisplay", "(Lnet/minecraft/class_1799;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)V", "", "calcDurability", "Lcom/dulkirfabric/events/PlaySoundEvent;", "event", "onSound", "(Lcom/dulkirfabric/events/PlaySoundEvent;)V", "Lcom/dulkirfabric/events/WorldLoadEvent;", "onWorldLoad", "(Lcom/dulkirfabric/events/WorldLoadEvent;)V", "Lcom/dulkirfabric/util/TrackedCooldown;", "fetchCooldownItem", "(Lnet/minecraft/class_1799;)Lcom/dulkirfabric/util/TrackedCooldown;", "", "Lcom/dulkirfabric/util/SoundInfo;", "trackedCooldowns", "Ljava/util/Map;", "", "lastRagTick", "J", "dulkirmod-fabric"})
@SourceDebugExtension(value={"SMAP\nCooldownDisplays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CooldownDisplays.kt\ncom/dulkirfabric/features/CooldownDisplays\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,103:1\n216#2,2:104\n216#2,2:106\n*S KotlinDebug\n*F\n+ 1 CooldownDisplays.kt\ncom/dulkirfabric/features/CooldownDisplays\n*L\n88#1:104,2\n97#1:106,2\n*E\n"})
public final class CooldownDisplays {
    @NotNull
    public static final CooldownDisplays INSTANCE = new CooldownDisplays();
    @NotNull
    private static final Map<SoundInfo, TrackedCooldown> trackedCooldowns;
    private static long lastRagTick;

    private CooldownDisplays() {
    }

    public final void shouldDisplay(@NotNull class_1799 stack, @NotNull CallbackInfoReturnable<Boolean> cir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        TrackedCooldown trackedCooldown = this.fetchCooldownItem(stack);
        if (trackedCooldown == null) {
            return;
        }
        TrackedCooldown cooldown = trackedCooldown;
        cir.setReturnValue((Object)(System.currentTimeMillis() - cooldown.getLastUsage() < (long)cooldown.getCooldownDuration() ? 1 : 0));
    }

    public final void calcDurability(@NotNull class_1799 stack, @NotNull CallbackInfoReturnable<Integer> cir) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(cir, (String)"cir");
        TrackedCooldown trackedCooldown = this.fetchCooldownItem(stack);
        if (trackedCooldown == null) {
            return;
        }
        TrackedCooldown cooldown = trackedCooldown;
        cir.setReturnValue((Object)((int)Math.rint(13.0f * (float)(System.currentTimeMillis() - cooldown.getLastUsage()) / (float)cooldown.getCooldownDuration())));
    }

    @EventHandler
    public final void onSound(@NotNull PlaySoundEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!DulkirConfig.ConfigVars.getConfigOptions().getDuraCooldown()) {
            return;
        }
        String path = event.getSound().method_4775().method_12832();
        float pitch = event.getSound().method_4782();
        float volume = event.getSound().method_4781();
        Intrinsics.checkNotNull((Object)path);
        TrackedCooldown trackedCooldown = trackedCooldowns.get(new SoundInfo(path, pitch, volume));
        if (trackedCooldown == null) {
            return;
        }
        TrackedCooldown matchResult = trackedCooldown;
        if (matchResult.getItemID().matches((CharSequence)"RAGNAROCK_AXE")) {
            if (System.currentTimeMillis() - lastRagTick < 5000L) {
                lastRagTick = System.currentTimeMillis();
                return;
            }
            lastRagTick = System.currentTimeMillis();
        }
        matchResult.setLastUsage(System.currentTimeMillis());
    }

    @EventHandler
    public final void onWorldLoad(@NotNull WorldLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!DulkirConfig.ConfigVars.getConfigOptions().getDuraCooldown()) {
            return;
        }
        Map<SoundInfo, TrackedCooldown> $this$forEach$iv = trackedCooldowns;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SoundInfo, TrackedCooldown>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SoundInfo, TrackedCooldown> element$iv;
            Map.Entry<SoundInfo, TrackedCooldown> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().setLastUsage(0L);
        }
    }

    private final TrackedCooldown fetchCooldownItem(class_1799 stack) {
        class_2487 class_24872 = Utils.INSTANCE.getNbt(stack);
        if (class_24872 == null) {
            return null;
        }
        class_2487 tag = class_24872;
        Optional optional = tag.method_10562("ExtraAttributes");
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getCompound(...)");
        class_2487 class_24873 = (class_2487)OptionalsKt.getOrNull((Optional)optional);
        if (class_24873 == null || (class_24873 = class_24873.method_10580("id")) == null) {
            return null;
        }
        class_2487 id = class_24873;
        char[] cArray = new char[]{'\"'};
        String idStr = StringsKt.trim((String)id.toString(), (char[])cArray);
        Map<SoundInfo, TrackedCooldown> $this$forEach$iv = trackedCooldowns;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<SoundInfo, TrackedCooldown>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SoundInfo, TrackedCooldown> element$iv;
            Map.Entry<SoundInfo, TrackedCooldown> it = element$iv = iterator.next();
            boolean bl = false;
            CharSequence charSequence = idStr;
            if (!it.getValue().getItemID().matches(charSequence)) continue;
            return it.getValue();
        }
        return null;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)new SoundInfo("entity.zombie_villager.cure", 1.0f, 0.5f), (Object)new TrackedCooldown(new Regex("(REAPER_CHESTPLATE)|(REAPER_LEGGINGS)|(REAPER_BOOTS)"), 25000, 0L)), new Pair((Object)new SoundInfo("entity.zombie_villager.cure", 0.6984127f, 1.0f), (Object)new TrackedCooldown(new Regex("(HYPERION|ASTRAEA|SCYLLA|VALKYRIE)"), 5000, 0L)), new Pair((Object)new SoundInfo("entity.firework_rocket.launch", 1.0f, 3.0f), (Object)new TrackedCooldown(new Regex("SOS_FLARE"), 20000, 0L)), new Pair((Object)new SoundInfo("block.lever.click", 2.0f, 0.55f), (Object)new TrackedCooldown(new Regex("RAGNAROCK_AXE"), 20000, 0L)), new Pair((Object)new SoundInfo("entity.generic.drink", 1.7936507f, 1.0f), (Object)new TrackedCooldown(new Regex("HOLY_ICE"), 4000, 0L)), new Pair((Object)new SoundInfo("entity.wolf.howl", 1.5238096f, 0.5f), (Object)new TrackedCooldown(new Regex("WEIRDER_TUBA"), 20000, 0L)), new Pair((Object)new SoundInfo("block.lava.pop", 2.0f, 0.4f), (Object)new TrackedCooldown(new Regex("ROGUE_SWORD"), 30000, 0L)), new Pair((Object)new SoundInfo("block.anvil.land", 0.4920635f, 1.0f), (Object)new TrackedCooldown(new Regex("GIANTS_SWORD"), 30000, 0L))};
        trackedCooldowns = MapsKt.mapOf((Pair[])pairArray);
    }
}

