/*
 * Decompiled with CFR 0.152.
 */
package com.dulkirfabric.features.slayer;

import com.dulkirfabric.config.DulkirConfig;
import com.dulkirfabric.events.SlayerBossEvents;
import com.dulkirfabric.util.TextUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import meteordevelopment.orbit.EventHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0016\u0010\r\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/dulkirfabric/features/slayer/BossTimer;", "", "<init>", "()V", "Lcom/dulkirfabric/events/SlayerBossEvents$Spawn;", "event", "", "onSlayerStart", "(Lcom/dulkirfabric/events/SlayerBossEvents$Spawn;)V", "Lcom/dulkirfabric/events/SlayerBossEvents$Kill;", "onSlayerKill", "(Lcom/dulkirfabric/events/SlayerBossEvents$Kill;)V", "", "lastSpawnTime", "J", "", "lastType", "Ljava/lang/String;", "dulkirmod-fabric"})
public final class BossTimer {
    @NotNull
    public static final BossTimer INSTANCE = new BossTimer();
    private static long lastSpawnTime;
    @NotNull
    private static String lastType;

    private BossTimer() {
    }

    @EventHandler
    public final void onSlayerStart(@NotNull SlayerBossEvents.Spawn event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        lastType = event.getType();
        lastSpawnTime = event.getTimestamp();
    }

    @EventHandler
    public final void onSlayerKill(@NotNull SlayerBossEvents.Kill event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!DulkirConfig.ConfigVars.getConfigOptions().getSlayerKillTime()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)lastType, (Object)event.getType())) {
            return;
        }
        float bossTime = (float)(event.getTimestamp() - lastSpawnTime) / 1000.0f;
        String string = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf(bossTime)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        TextUtils.info$default(TextUtils.INSTANCE, "\u00a76Slayer Boss took " + string2 + "s to kill.", false, 2, null);
    }

    static {
        lastType = "";
    }
}

