/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp;

import bnb.tfp.CommonClass;
import bnb.tfp.Constants;
import bnb.tfp.FabricNetworking;
import bnb.tfp.TFPData;
import bnb.tfp.command.TransformerCommands;
import bnb.tfp.reg.ModItems;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FabricCommonClass
implements ModInitializer {
    public void onInitialize() {
        Constants.LOG.info("Hello Fabric world!");
        CommonClass.init();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)new class_2960("tfp", "tfp"), (Object)ModItems.buildTab(FabricItemGroup.builder()));
        FabricNetworking.init();
        CommandRegistrationCallback.EVENT.register((dispatcher, ctx, selection) -> TransformerCommands.init(arg_0 -> ((CommandDispatcher)dispatcher).register(arg_0)));
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            PlayableTransformer transformer = TFPData.getInstance(world).getTransformer(player);
            return transformer == null || !transformer.isUsingGun(player);
        });
        PlayerBlockBreakEvents.AFTER.register((lvl, player, pos, state, entity) -> {
            if (player == null || player.method_18276()) {
                return;
            }
            PlayableTransformer transformer = TFPData.getTransformerStatic(player);
            if (transformer == null || !transformer.isMinerMode()) {
                return;
            }
            for (int x = pos.method_10263() - 1; x <= pos.method_10263() + 1; ++x) {
                for (int y = pos.method_10264() - 1; y <= pos.method_10264() + 1; ++y) {
                    for (int z = pos.method_10260() - 1; z <= pos.method_10260() + 1; ++z) {
                        class_2338 pos1 = new class_2338(x, y, z);
                        if (pos.equals((Object)pos1) || !lvl.method_8320(pos1).equals(state)) continue;
                        lvl.method_8651(pos1, false, (class_1297)player);
                        if (player.method_31549().field_7477 || !player.method_7305(state)) continue;
                        class_2248.method_9511((class_2680)state, (class_1937)lvl, (class_2338)pos1, (class_2586)lvl.method_8321(pos1), (class_1297)player, (class_1799)player.method_6047());
                    }
                }
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            PlayableTransformer transformer = TFPData.serverInstance(newPlayer.field_13995).getTransformer((class_1657)newPlayer);
            if (transformer != null) {
                transformer.setupTransformer(newPlayer);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            ModNetworking.send(player, new TFPData.ClientboundPacket(TFPData.serverInstance(server)));
            player.method_18382();
        });
        FabricCommonClass.addFeature(ctx -> ctx.canGenerateIn(class_5363.field_25412), class_2893.class_2895.field_13176, "energon_deposit");
        FabricCommonClass.addFeature(ctx -> ctx.getBiomeKey().equals(class_1972.field_22075), class_2893.class_2895.field_13176, "nether_energon_deposit");
        FabricCommonClass.addFeature(ctx -> ctx.canGenerateIn(class_5363.field_25412), class_2893.class_2895.field_13176, "red_energon_deposit");
        FabricCommonClass.addFeature(ctx -> ctx.getBiomeKey().equals(class_1972.field_22077), class_2893.class_2895.field_13176, "nether_red_energon_deposit");
        FabricCommonClass.addFeature(ctx -> ctx.canGenerateIn(class_5363.field_25412), class_2893.class_2895.field_13176, "dark_energon_deposit");
    }

    public static void addFeature(Predicate<BiomeSelectionContext> biomes, class_2893.class_2895 step, String id) {
        BiomeModifications.addFeature(biomes, (class_2893.class_2895)step, (class_5321)class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("tfp", id)));
    }
}

