/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp;

import bnb.tfp.network.ModClientboundPacket;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;

public class TFPData
extends class_18 {
    private final HashMap<UUID, PlayableTransformer> transformers;
    private static final TFPData CLIENT_INSTANCE = new TFPData(){

        public void method_78(boolean p_77761_) {
        }
    };

    private TFPData() {
        this(new HashMap<UUID, PlayableTransformer>());
    }

    private TFPData(HashMap<UUID, PlayableTransformer> transformers) {
        this.transformers = transformers;
    }

    public TFPData load(class_2487 tag) {
        this.transformers.clear();
        tag.method_10541().forEach(string -> this.transformers.put(UUID.fromString(string), PlayableTransformer.fromNbt(tag.method_10562(string))));
        return this;
    }

    @Nonnull
    public class_2487 method_75(@Nonnull class_2487 tag) {
        this.transformers.forEach((uuid, transformer) -> {
            class_2487 tag1 = new class_2487();
            tag1.method_10582("Type", transformer.getType().getName());
            transformer.save(tag1);
            tag.method_10566(uuid.toString(), (class_2520)tag1);
        });
        return tag;
    }

    public PlayableTransformer getTransformer(UUID uuid) {
        return this.transformers.get(uuid);
    }

    public PlayableTransformer getTransformer(class_1657 player) {
        try {
            return player.method_7325() ? null : this.getTransformer(player.method_5667());
        }
        catch (NullPointerException ingnored) {
            return this.getTransformer(player.method_5667());
        }
    }

    public boolean isTransformer(UUID uuid) {
        return this.transformers.containsKey(uuid);
    }

    public boolean isTransformer(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        try {
            return !player.method_7325() && this.isTransformer(player.method_5667());
        }
        catch (NullPointerException ignored) {
            return this.isTransformer(player.method_5667());
        }
    }

    public Set<UUID> getTransformerPlayersUUIDs() {
        return Set.copyOf(this.transformers.keySet());
    }

    public boolean setTransformer(UUID uuid, PlayableTransformer transformer) {
        if (!transformer.getType().canUseVariant(this, transformer.getColors(), uuid)) {
            return false;
        }
        this.transformers.put(uuid, transformer);
        this.method_80();
        return true;
    }

    public boolean setTransformer(class_1657 player, PlayableTransformer transformer) {
        return this.setTransformer(player.method_5667(), transformer);
    }

    public void clearTransformer(UUID uuid) {
        this.transformers.remove(uuid);
        this.method_80();
    }

    public void clearTransformer(class_1657 player) {
        this.clearTransformer(player.method_5667());
    }

    public boolean contains(BiPredicate<UUID, PlayableTransformer> predicate) {
        return this.transformers.entrySet().stream().anyMatch(entry -> predicate.test((UUID)entry.getKey(), (PlayableTransformer)entry.getValue()));
    }

    public static TFPData clientInstance() {
        return CLIENT_INSTANCE;
    }

    public static TFPData serverInstance(MinecraftServer server) {
        return (TFPData)server.method_30002().method_17983().method_17924(tag -> new TFPData().load((class_2487)tag), TFPData::new, "tfp_data");
    }

    public static TFPData getInstance(class_1937 lvl) {
        return lvl.field_9236 ? CLIENT_INSTANCE : TFPData.serverInstance(Objects.requireNonNull(lvl.method_8503()));
    }

    public static PlayableTransformer getTransformerStatic(class_1657 player) {
        return TFPData.getInstance(player.method_37908()).getTransformer(player);
    }

    public static boolean isTransformerStatic(class_1297 entity) {
        return TFPData.getInstance(entity.method_37908()).isTransformer(entity);
    }

    public static class ClientboundPacket
    implements ModClientboundPacket {
        private final class_2487 data;

        protected ClientboundPacket(class_2487 data) {
            this.data = data;
        }

        public ClientboundPacket(TFPData tfpData) {
            this(tfpData.method_75(new class_2487()));
        }

        public ClientboundPacket(class_2540 buf) {
            this(Objects.requireNonNull(buf.method_10798()));
        }

        @Override
        public void write(class_2540 buf) {
            buf.method_10794(this.data);
        }

        @Override
        public void handle(class_310 mc) {
            CLIENT_INSTANCE.load(this.data);
            if (mc.field_1724 != null) {
                mc.field_1724.method_18382();
            }
        }
    }
}

