/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.blockentity;

import bnb.tfp.inventory.EnergonConverterMenu;
import bnb.tfp.reg.ModBlockEntities;
import bnb.tfp.reg.ModItems;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3913;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class EnergonConverterBlockEntity
extends class_2624 {
    public static final List<Map<class_1792, Integer>> INGREDIENT_VALUES = List.of(Map.of(class_1802.field_8281, 1, class_1802.field_22421, 5), Map.of(class_1802.field_8705, 1, class_1802.field_8070, 4), Map.of(class_1802.field_8328, 1, class_1802.field_8067, 2, class_1802.field_21999, 2, class_1802.field_8790, 6), Map.of(class_1802.field_20399, 1, class_1802.field_8233, 3, class_1802.field_8634, 6, class_1802.field_8815, 8));
    private final class_2371<class_1799> items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    protected class_3913 dataAccess = new class_3913(){

        public int method_17390(int i) {
            return switch (i) {
                case 0 -> EnergonConverterBlockEntity.this.energy;
                case 1 -> EnergonConverterBlockEntity.this.xpPoints;
                default -> 0;
            };
        }

        public void method_17391(int i, int i1) {
            switch (i) {
                case 0: {
                    EnergonConverterBlockEntity.this.energy = i1;
                    break;
                }
                case 1: {
                    EnergonConverterBlockEntity.this.xpPoints = i1;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int energy;
    private int xpPoints;
    public float mixerRot;
    public float rotSpeed;

    public EnergonConverterBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.ENERGON_CONVERTER.get(), pos, blockState);
    }

    public static boolean tick(int energy, class_1937 lvl, EnergonConverterBlockEntity blockEntity, float minCoef) {
        if (energy <= 0) {
            blockEntity.rotSpeed *= 0.95f;
            return false;
        }
        if (blockEntity.method_5438(7).method_7960() || !blockEntity.method_5438(0).method_7960() || blockEntity.method_5438(1).method_7947() < 4 || blockEntity.method_5438(2).method_7960() || IntStream.range(0, 4).anyMatch(i -> !INGREDIENT_VALUES.get(i).containsKey(blockEntity.method_5438(i + 3).method_7909()))) {
            blockEntity.energy = 0;
            blockEntity.rotSpeed *= 0.95f;
            return false;
        }
        blockEntity.energy += energy;
        if (blockEntity.rotSpeed < 2.5f) {
            blockEntity.rotSpeed += 0.0625f;
        }
        if (blockEntity.energy > 9000) {
            int quality = IntStream.range(0, 4).map(i -> INGREDIENT_VALUES.get(i).get(blockEntity.method_5438(i + 3).method_7909())).sum();
            class_1799 syringes = blockEntity.method_5438(7);
            int amount = Math.min(8 + lvl.field_9229.method_39332(Math.round(minCoef * (float)quality), 2 * quality), syringes.method_7947());
            blockEntity.method_5447(0, new class_1799((class_1935)ModItems.SYNTH_EN.get(), amount));
            blockEntity.method_5438(1).method_7934(4);
            for (int i2 = 2; i2 < 7; ++i2) {
                class_1799 stack = blockEntity.method_5438(i2);
                class_1792 remaining = stack.method_7909().method_7858();
                stack.method_7934(1);
                if (!stack.method_7960() || remaining == null) continue;
                blockEntity.method_5447(i2, remaining.method_7854());
            }
            syringes.method_7934(amount);
            blockEntity.xpPoints += quality;
            blockEntity.energy = 0;
        }
        return true;
    }

    public static void tick(class_1937 lvl, class_2338 pos, class_2680 state, EnergonConverterBlockEntity blockEntity) {
        blockEntity.mixerRot += blockEntity.rotSpeed;
        EnergonConverterBlockEntity.tick(lvl.method_49804(pos), lvl, blockEntity, 1.0f);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.tfp.energon_converter");
    }

    protected class_1703 method_5465(int id, class_1661 inventory) {
        return new EnergonConverterMenu(id, inventory, (class_1263)this, this.dataAccess);
    }

    public int method_5439() {
        return 8;
    }

    public boolean method_5442() {
        for (class_1799 item : this.items) {
            if (item.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int i) {
        return (class_1799)this.items.get(i);
    }

    public class_1799 method_5434(int i, int count) {
        return class_1262.method_5430(this.items, (int)i, (int)count);
    }

    public class_1799 method_5441(int i) {
        return class_1262.method_5428(this.items, (int)i);
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.items.set(i, (Object)itemStack);
    }

    public boolean method_5443(class_1657 player) {
        return class_1263.method_49105((class_2586)this, (class_1657)player);
    }

    public void method_5448() {
        this.items.clear();
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index <= 0) {
            return false;
        }
        try {
            return INGREDIENT_VALUES.get(index - 3).containsKey(stack.method_7909());
        }
        catch (IndexOutOfBoundsException e) {
            return stack.method_31574(switch (index) {
                case 1 -> class_1802.field_8687;
                case 2 -> class_1802.field_8183;
                default -> ModItems.SYRINGE.get();
            });
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public float getConvertingProcess() {
        return (float)this.energy / 9000.0f;
    }

    public int getXpPoints() {
        return this.xpPoints;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items.clear();
        class_1262.method_5429((class_2487)tag, this.items);
        this.energy = tag.method_10550("Energy");
        this.xpPoints = tag.method_10550("XpPoints");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10569("Energy", this.energy);
        tag.method_10569("XpPoints", this.xpPoints);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

