/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.blockentity;

import bnb.tfp.TFPData;
import bnb.tfp.reg.ModBlockEntities;
import bnb.tfp.reg.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class LaptopBlockEntity
extends class_2586 {
    private static final class_2350[] DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    private Optional<UUID> tracked = Optional.empty();
    private class_2338 trackedPos = class_2338.field_10980;
    public HashMap<class_2350.class_2351, Integer> axisTicks = new HashMap<class_2350.class_2351, Integer>(Map.of(class_2350.class_2351.field_11048, 0, class_2350.class_2351.field_11052, 0, class_2350.class_2351.field_11051, 0));

    protected LaptopBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public LaptopBlockEntity(class_2338 pos, class_2680 state) {
        this(ModBlockEntities.LAPTOP.get(), pos, state);
    }

    public static boolean canTrackPlayer(class_1657 player, class_2338 pos) {
        return TFPData.isTransformerStatic((class_1297)player) && player.method_19538().method_1022(pos.method_46558()) <= 4096.0;
    }

    public Optional<UUID> getTracked() {
        return this.tracked;
    }

    public class_2338 getTrackedPos() {
        return this.trackedPos;
    }

    public void setTracked(@Nullable UUID tracked) {
        this.tracked = Optional.ofNullable(tracked);
        this.method_5431();
    }

    public void updateTracking(class_1937 lvl, class_2338 pos) {
        this.tracked.map(arg_0 -> ((class_1937)lvl).method_18470(arg_0)).ifPresentOrElse(player -> {
            if (!LaptopBlockEntity.isConnectedToSignalNavigator(lvl, pos) || !LaptopBlockEntity.canTrackPlayer(player, pos)) {
                this.setTracked(null);
            }
            if (this.trackedPos != player.method_24515()) {
                this.trackedPos = player.method_24515();
                this.method_5431();
            }
        }, () -> this.setTracked(null));
        class_2680 state = lvl.method_8320(pos);
        lvl.method_8413(pos, state, state, 3);
    }

    private static boolean isConnectedToSignalNavigator(class_1937 lvl, class_2338 pos) {
        for (class_2350 direction : DIRECTIONS) {
            if (!lvl.method_8320(pos.method_10093(direction)).method_27852((class_2248)ModBlocks.SIGNAL_NAVIGATOR.get())) continue;
            return true;
        }
        return false;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.tracked.ifPresent(uuid -> tag.method_25927("Tracked", uuid));
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        Optional<Object> optional = this.tracked = tag.method_10545("Tracked") ? Optional.of(tag.method_25926("Tracked")) : Optional.empty();
        if (tag.method_10545("TrackedPos")) {
            int[] pos = tag.method_10561("TrackedPos");
            if (this.getTrackedPos().method_10263() != pos[0]) {
                this.axisTicks.put(class_2350.class_2351.field_11048, 0);
            }
            if (this.getTrackedPos().method_10264() != pos[1]) {
                this.axisTicks.put(class_2350.class_2351.field_11052, 0);
            }
            if (this.getTrackedPos().method_10260() != pos[2]) {
                this.axisTicks.put(class_2350.class_2351.field_11051, 0);
            }
            this.trackedPos = new class_2338(pos[0], pos[1], pos[2]);
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 tag = this.method_38244();
        tag.method_10539("TrackedPos", new int[]{this.trackedPos.method_10263(), this.trackedPos.method_10264(), this.trackedPos.method_10260()});
        return tag;
    }
}

