/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.gui.screens;

import bnb.tfp.TFPData;
import bnb.tfp.network.SetTransformerPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_6328;
import net.minecraft.class_6382;
import org.joml.Quaternionf;

@class_6328
@ParametersAreNonnullByDefault
public class TransformerEditorScreen
extends class_437 {
    public static final class_2960 BG_TEXTURE = new class_2960("tfp", "textures/gui/transformer_editor.png");
    private static final class_2561 NO_LAYERS_COMPONENT = class_2561.method_43471((String)"gui.tfp.transformer_editor.no_layers").method_27692(class_124.field_1068);
    private static final class_2561 FACTION_COMPONENT = class_2561.method_43471((String)"gui.tfp.transformer_editor.faction").method_27692(class_124.field_1068);
    private static final class_2561 PASSENGERS_LIMIT_COMPONENT = class_2561.method_43471((String)"gui.tfp.transformer_editor.passengers_limit").method_27692(class_124.field_1068);
    private static final class_2561 MINER_MODE_COMPONENT = class_2561.method_43471((String)"gui.tfp.transformer_editor.miner_mode").method_27692(class_124.field_1068);
    private static final class_2561 F5_VEHICLE = class_2561.method_43471((String)"gui.tfp.transformer_editor.f5_vehicle").method_27692(class_124.field_1068);
    private final PlayableTransformer edited;
    @Nullable
    private TransformerColorLayer layer;
    @Nullable
    private ArrayDeque<HSBColor> originalColors;
    private final PlayableTransformer.Faction originalFaction;
    private final byte originalPassengersLimit;
    private final ArrayList<ColorButton> colorButtons;
    private BrightnessScrollWidget brightnessScrollWidget;
    private boolean rotating;
    private float yRot;
    private float yRotStep;

    public TransformerEditorScreen(PlayableTransformer transformer) {
        super((class_2561)class_2561.method_43471((String)"gui.tfp.transformer_editor"));
        this.edited = transformer;
        if (!this.edited.getVariant().isEmpty()) {
            this.layer = this.edited.getVariant().get(0);
        }
        this.originalColors = new ArrayDeque<HSBColor>(this.edited.getColors());
        this.originalFaction = this.edited.getFaction();
        this.originalPassengersLimit = this.edited.getPassengersLimit();
        this.colorButtons = new ArrayList();
    }

    protected void method_25426() {
        super.method_25426();
        int leftBorder = (this.field_22789 - 202) / 2;
        for (int hue = 0; hue < 24; ++hue) {
            for (int saturation = 8; saturation >= 0; --saturation) {
                this.colorButtons.add((ColorButton)this.method_37063((class_364)new ColorButton(leftBorder + 87 + hue * 4, 87 - saturation * 4, new HSBColor(hue, saturation, 8))));
            }
        }
        if (this.layer != null) {
            this.brightnessScrollWidget = (BrightnessScrollWidget)this.method_37063((class_364)new BrightnessScrollWidget(leftBorder + 87, 95));
            this.method_37063((class_364)new ChangeLayerButton(leftBorder + 86, 38, false));
            this.method_37063((class_364)new ChangeLayerButton(leftBorder + 174, 38, true));
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            ModNetworking.sendToServer(new SetTransformerPacket(this.edited));
            this.originalColors = null;
            this.method_25419();
        }).method_46434(leftBorder + 130, 174, 64, 16).method_46431());
        this.method_37063((class_364)new FactionButton(leftBorder + this.field_22793.method_27525((class_5348)FACTION_COMPONENT) + 87, 111));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.edited.isMinerMode() ? "options.on" : "options.off")), button -> {
            this.edited.setMinerMode(!this.edited.isMinerMode());
            button.method_25355((class_2561)class_2561.method_43471((String)(this.edited.isMinerMode() ? "options.on" : "options.off")));
        }).method_46434(leftBorder + this.field_22793.method_27525((class_5348)MINER_MODE_COMPONENT) + 87, 128, 32, 12).method_46431());
        if (this.edited.getType().getMaxPassengers() > 0) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(this.edited.getPassengersLimit())), button -> {
                byte passengers = this.edited.getPassengersLimit();
                if ((passengers = (byte)(passengers + 1)) > this.edited.getType().getMaxPassengers() || passengers < 0) {
                    passengers = 0;
                }
                this.edited.setPassengersLimit(passengers);
                button.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(passengers)));
            }).method_46434(leftBorder + this.field_22793.method_27525((class_5348)PASSENGERS_LIMIT_COMPONENT) + 87, 141, 20, 12).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)(this.edited.getF5Vehicle() ? "options.on" : "options.off")), button -> {
            this.edited.setF5Vehicle(!this.edited.getF5Vehicle());
            button.method_25355((class_2561)class_2561.method_43471((String)(this.edited.getF5Vehicle() ? "options.on" : "options.off")));
        }).method_46434(leftBorder + this.field_22793.method_27525((class_5348)F5_VEHICLE) + 87, 154, 32, 12).method_46431());
    }

    public void method_25394(class_332 graphics, int cursorX, int cursorY, float partialTick) {
        this.method_25420(graphics);
        assert (this.field_22787 != null);
        int leftBorder = (this.field_22789 - 202) / 2;
        class_2561 component = this.layer != null ? this.layer.getComponent() : NO_LAYERS_COMPONENT;
        graphics.method_51439(this.field_22793, component, leftBorder + 134 - this.field_22793.method_27525((class_5348)component) / 2, 39, 0, false);
        this.yRotStep *= 0.95f;
        this.yRot += this.yRotStep;
        TransformerEditorScreen.renderEntity(graphics, leftBorder + 39, 156, 64, 118, this.yRot, (class_1309)Objects.requireNonNull(this.field_22787.field_1724));
        graphics.method_51439(this.field_22793, FACTION_COMPONENT, leftBorder + 87, 111, 0, false);
        graphics.method_51439(this.field_22793, MINER_MODE_COMPONENT, leftBorder + 87, 128, 0, false);
        graphics.method_51439(this.field_22793, F5_VEHICLE, leftBorder + 87, 154, 0, false);
        if (this.edited.getType().getMaxPassengers() > 0) {
            graphics.method_51439(this.field_22793, PASSENGERS_LIMIT_COMPONENT, leftBorder + 87, 141, 0, false);
        }
        super.method_25394(graphics, cursorX, cursorY, partialTick);
    }

    public void method_25420(class_332 graphics) {
        super.method_25420(graphics);
        graphics.method_25302(BG_TEXTURE, (this.field_22789 - 202) / 2, 32, 0, 0, 202, 166);
    }

    public static void renderEntity(class_332 graphics, int x, int y, int windowWidth, int windowHeight, float yRot, class_1309 entity) {
        float yBodyRot = entity.field_6283;
        float yRot1 = entity.method_36454();
        float xRot = entity.method_36455();
        float yHeadRotO = entity.field_6259;
        float yHeadRot = entity.field_6241;
        entity.field_6283 = 180.0f + yRot;
        entity.method_36456(180.0f + yRot);
        entity.method_36457(0.0f);
        entity.field_6259 = 180.0f + yRot;
        entity.field_6241 = 180.0f + yRot;
        class_490.method_48472((class_332)graphics, (int)x, (int)y, (int)((int)Math.min((double)((float)windowWidth / entity.method_17681()) / 2.5, (double)((float)windowHeight / entity.method_17682()))), (Quaternionf)new Quaternionf().rotateZ((float)Math.PI), null, (class_1309)entity);
        entity.field_6283 = yBodyRot;
        entity.method_36456(yRot1);
        entity.method_36457(xRot);
        entity.field_6259 = yHeadRotO;
        entity.field_6241 = yHeadRot;
    }

    public boolean method_25402(double x, double y, int button) {
        int leftBorder = (this.field_22789 - 202) / 2;
        if (x > (double)(leftBorder + 7) && x < (double)(leftBorder + 71) && y > 39.0 && y < 158.0) {
            this.rotating = true;
            return true;
        }
        return super.method_25402(x, y, button);
    }

    public boolean method_25406(double x, double y, int button) {
        if (this.rotating) {
            this.rotating = false;
            return true;
        }
        return super.method_25406(x, y, button);
    }

    public boolean method_25403(double cursorX, double cursorY, int button, double draggedX, double draggedY) {
        if (this.rotating) {
            this.yRotStep -= (float)draggedX * 0.1f;
        }
        return super.method_25403(cursorX, cursorY, button, draggedX, draggedY);
    }

    public void method_25419() {
        if (this.originalColors != null) {
            this.edited.getVariant().forEach(layer -> layer.setColor(this.originalColors.poll()));
            this.edited.setFaction(this.originalFaction);
            this.edited.setPassengersLimit(this.originalPassengersLimit);
        }
        super.method_25419();
    }

    protected class ColorButton
    extends class_339 {
        private HSBColor color;

        public ColorButton(int x, int y, HSBColor color) {
            super(x, y, 4, 4, (class_2561)class_2561.method_43471((String)"gui.tfp.transformer_editor.color"));
            this.color = color;
            this.update();
        }

        public void setBrightness(int brightness) {
            this.color = this.color.copyWithBrightness(brightness);
        }

        public void update() {
            if (TransformerEditorScreen.this.layer != null) {
                ArrayList<HSBColor> variant = new ArrayList<HSBColor>(TransformerEditorScreen.this.edited.getVariant().stream().map(TransformerColorLayer::getColor).toList());
                variant.set(variant.indexOf(TransformerEditorScreen.this.layer.getColor()), this.color);
                this.field_22764 = TransformerEditorScreen.this.edited.getType().canUseVariant(TFPData.clientInstance(), variant, Objects.requireNonNull(Objects.requireNonNull(((TransformerEditorScreen)TransformerEditorScreen.this).field_22787).field_1724).method_5667());
            }
        }

        public void method_25348(double cursorX, double cursorY) {
            if (this.field_22764 && TransformerEditorScreen.this.layer != null) {
                TransformerEditorScreen.this.layer.setColor(this.color);
            }
        }

        protected void method_47399(class_6382 var1) {
        }

        protected void method_48579(class_332 graphics, int cursorX, int cursorY, float partialTick) {
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, TransformerEditorScreen.this.layer == null || !TransformerEditorScreen.this.layer.getColor().equals(this.color) ? this.color.argb : class_5253.class_5254.method_48780((float)class_3532.method_15379((float)class_3532.method_15374((float)((float)class_156.method_658() * (float)Math.PI / 2000.0f))), (int)this.color.argb, (int)(this.color.argb == -1 ? -4210753 : -1)));
        }
    }

    protected class BrightnessScrollWidget
    extends class_339 {
        public static final class_2960 SCROLL_LOCATION = new class_2960("tfp", "textures/gui/sprites/transformer_editor/brightness_scroll.png");
        public static final class_2960 SLIDER_LOCATION = new class_2960("tfp", "textures/gui/sprites/transformer_editor/brightness_slider.png");
        private int value;

        public BrightnessScrollWidget(int x, int y) {
            super(x, y, 96, 8, (class_2561)class_2561.method_43471((String)"gui.tfp.transformer_editor.change_brightness"));
            this.value = 8;
        }

        protected void method_48579(class_332 graphics, int cursorX, int cursorY, float partialTick) {
            float[] rgb = Objects.requireNonNull(TransformerEditorScreen.this.layer).getColor().copyWithBrightness(7).rgbFloats();
            graphics.method_51422(rgb[0], rgb[1], rgb[2], 1.0f);
            graphics.method_25290(SCROLL_LOCATION, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 96, 8, 96, 8);
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.method_25290(SLIDER_LOCATION, this.method_46426() + this.value * 12 - 8, this.method_46427() - 1, 0.0f, 0.0f, 4, 10, 4, 10);
        }

        protected void method_25349(double cursorX, double cursorY, double draggedX, double draggedY) {
            if (this.field_22764 && this.setBrightness(class_3532.method_15340((int)((int)((cursorX - (double)this.method_46426()) / 12.0) + 1), (int)1, (int)8))) {
                TransformerEditorScreen.this.colorButtons.forEach(ColorButton::update);
            }
            super.method_25349(cursorX, cursorY, draggedX, draggedY);
        }

        public boolean setBrightness(int value) {
            if (value == this.value) {
                return false;
            }
            this.value = value;
            TransformerEditorScreen.this.colorButtons.forEach(colorButton -> colorButton.setBrightness(value));
            return true;
        }

        protected void method_47399(class_6382 var1) {
            this.method_37021(var1);
        }
    }

    protected class ChangeLayerButton
    extends class_339 {
        private final boolean forward;
        public static final class_2960 NEXT_TEXTURE = new class_2960("tfp", "textures/gui/sprites/transformer_editor/next.png");
        public static final class_2960 NEXT_HIGHLIGHTED_TEXTURE = new class_2960("tfp", "textures/gui/sprites/transformer_editor/next_highlighted.png");
        public static final class_2960 PREVIOUS_TEXTURE = new class_2960("tfp", "textures/gui/sprites/transformer_editor/previous.png");
        public static final class_2960 PREVIOUS_HIGHLIGHTED_TEXTURE = new class_2960("tfp", "textures/gui/sprites/transformer_editor/previous_highlighted.png");

        public ChangeLayerButton(int x, int y, boolean forward) {
            super(x, y, 10, 10, (class_2561)class_2561.method_43471((String)"gui.tfp.transformer_editor.change_layer"));
            this.forward = forward;
        }

        protected void method_48579(class_332 graphics, int cursorX, int cursorY, float partialTick) {
            graphics.method_25290(this.forward ? (this.method_25367() ? NEXT_HIGHLIGHTED_TEXTURE : NEXT_TEXTURE) : (this.method_25367() ? PREVIOUS_HIGHLIGHTED_TEXTURE : PREVIOUS_TEXTURE), this.method_46426(), this.method_46427(), 0.0f, 0.0f, 10, 10, 10, 10);
        }

        public void method_25348(double cursorX, double cursorY) {
            List<TransformerColorLayer> layers = TransformerEditorScreen.this.edited.getVariant();
            int index = layers.indexOf(TransformerEditorScreen.this.layer);
            if ((this.forward ? ++index : --index) < 0) {
                index = layers.size() - 1;
            } else if (index >= layers.size()) {
                index = 0;
            }
            TransformerEditorScreen.this.layer = layers.get(index);
            if (TransformerEditorScreen.this.layer.brightColorsOnly()) {
                TransformerEditorScreen.this.brightnessScrollWidget.field_22764 = false;
                TransformerEditorScreen.this.brightnessScrollWidget.setBrightness(8);
            } else {
                TransformerEditorScreen.this.brightnessScrollWidget.field_22764 = true;
            }
            TransformerEditorScreen.this.colorButtons.forEach(ColorButton::update);
        }

        protected void method_47399(class_6382 var1) {
            this.method_37021(var1);
        }
    }

    protected class FactionButton
    extends class_339 {
        public final class_2960 AUTOBOTS_TEXTURE;
        public final class_2960 DECEPTICONS_TEXTURE;

        public FactionButton(int x, int y) {
            super(x, y, 16, 16, FACTION_COMPONENT);
            this.AUTOBOTS_TEXTURE = new class_2960("tfp", "textures/item/autobots_icon.png");
            this.DECEPTICONS_TEXTURE = new class_2960("tfp", "textures/item/decepticons_icon.png");
        }

        protected void method_48579(class_332 graphics, int cursorX, int cursorY, float partialTick) {
            boolean autobot = TransformerEditorScreen.this.edited.getFaction() == PlayableTransformer.Faction.AUTOBOTS;
            graphics.method_25290(autobot ? this.AUTOBOTS_TEXTURE : this.DECEPTICONS_TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 16, 16, 16, 16);
            if (this.method_49606()) {
                graphics.method_51447(TransformerEditorScreen.this.field_22793, List.of((autobot ? PlayableTransformer.Faction.AUTOBOTS : PlayableTransformer.Faction.DECEPTICONS).getComponent().method_30937(), class_2561.method_43471((String)"gui.tfp.transformer_editor.click2change").method_30937()), cursorX, cursorY);
            }
        }

        public void method_25348(double cursorX, double cursorY) {
            TransformerEditorScreen.this.edited.setFaction(TransformerEditorScreen.this.edited.getFaction() == PlayableTransformer.Faction.AUTOBOTS ? PlayableTransformer.Faction.DECEPTICONS : PlayableTransformer.Faction.AUTOBOTS);
        }

        protected void method_47399(class_6382 var1) {
            this.method_37021(var1);
        }
    }
}

