/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.bot;

import bnb.tfp.client.animation.AnimPair;
import bnb.tfp.client.animation.TransformerAnimations;
import bnb.tfp.client.model.transformer.AbstractTransformerModel;
import bnb.tfp.entity.TransformerAnimatable;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3881;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4896;
import net.minecraft.class_5602;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_6179;
import net.minecraft.class_630;
import net.minecraft.class_7094;
import net.minecraft.class_7184;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@class_6179
public abstract class AbstractTransformerBotModel<T extends class_1309, A extends TransformerAnimatable>
extends AbstractTransformerModel<T, A>
implements class_3881,
class_3882 {
    protected TransformerAnimations animations;
    public final class_572<T> humanoidModel = new class_572(class_310.method_1551().method_31974().method_32072(class_5602.field_27577));
    public static int x;
    public static int y;
    public static int z;
    public static int xRot;
    public static int yRot;
    public static int zRot;

    public AbstractTransformerBotModel(class_630 root, TransformerAnimations animations, Function<class_2960, class_1921> renderType) {
        super(root, renderType);
        this.humanoidModel.field_3448 = false;
        this.animations = animations;
    }

    public AbstractTransformerBotModel(class_630 root, TransformerAnimations animations) {
        this(root, animations, class_1921::method_23578);
    }

    public void translateToHand(class_1306 arm, class_4587 poseStack, float xOffset, float yOffset, float zOffset) {
        this.method_32008().method_22703(poseStack);
        this.getHandDirectory(arm).forEach(modelPart -> modelPart.method_22703(poseStack));
        poseStack.method_46416((arm == class_1306.field_6182 ? xOffset : -xOffset) / 16.0f, -yOffset / 16.0f, -zOffset / 16.0f);
    }

    public abstract void method_2803(class_1306 var1, class_4587 var2);

    public static void copyOffsetAndRot(class_630 part, class_630 part1) {
        class_5603 initial = part1.method_41921();
        part.method_41920(new Vector3f(part1.field_3657 - initial.field_27702, part1.field_3656 - initial.field_27703, part1.field_3655 - initial.field_27704));
        part.method_41922(new Vector3f(part1.field_3654 - initial.field_27705, part1.field_3675 - initial.field_27706, part1.field_3674 - initial.field_27707));
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.method_2816(entity, limbSwing, limbSwingAmount, partialTick);
        this.humanoidModel.method_17086(entity, limbSwing, limbSwingAmount, partialTick);
    }

    @Override
    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        class_630 head = this.method_2838();
        class_630 leftArm = this.getArm(class_1306.field_6182);
        class_630 rightArm = this.getArm(class_1306.field_6183);
        class_630 rightLeg = this.getRightLeg();
        class_630 leftLeg = this.getLeftLeg();
        if (this.humanoidModel.field_3396 > 0.0f) {
            this.humanoidModel.method_17087(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        } else {
            this.humanoidModel.method_17087(entity, 0.0f, 0.0f, ageInTicks, netHeadYaw, headPitch);
        }
        float yHeadRot = head.field_3675;
        float xHeadRot = head.field_3654;
        AbstractTransformerBotModel.copyOffsetAndRot(head, this.humanoidModel.field_3398);
        float headRot = this.states.getTransformAnimState().method_41327() ? 1.0f - this.transformationProgress() : this.transformationProgress();
        head.field_3675 = class_3532.method_17821((float)headRot, (float)yHeadRot, (float)head.field_3675);
        head.field_3654 = class_3532.method_17821((float)headRot, (float)xHeadRot, (float)head.field_3654);
        if (this.states.getTransformAnimState().method_41327()) {
            return;
        }
        AbstractTransformerBotModel.copyOffsetAndRot(rightArm, this.humanoidModel.field_3401);
        AbstractTransformerBotModel.copyOffsetAndRot(leftArm, this.humanoidModel.field_27433);
        if (this.humanoidModel.field_3396 > 0.0f) {
            AbstractTransformerBotModel.copyOffsetAndRot(rightLeg, this.humanoidModel.field_3392);
            AbstractTransformerBotModel.copyOffsetAndRot(leftLeg, this.humanoidModel.field_3397);
        } else {
            if (this.humanoidModel.field_3395 == class_572.class_573.field_3409 && !this.humanoidModel.field_3399.method_30156()) {
                class_4896.method_29350((class_630)rightArm, (float)ageInTicks, (float)-1.0f);
            }
            if (this.humanoidModel.field_3399 == class_572.class_573.field_3409 && !this.humanoidModel.field_3395.method_30156()) {
                class_4896.method_29350((class_630)leftArm, (float)ageInTicks, (float)1.0f);
            }
        }
        this.method_43781(this.states.getIdleAnimState(), this.animations.idleAnimation(), ageInTicks);
        this.method_43781(this.states.getSettleAnimState(), this.animations.settle(), ageInTicks);
        if (this.states.getRevertAnimState().method_41327()) {
            return;
        }
        if (this.states.getFallAnimState().method_41327()) {
            this.method_43782(this.states.getFallAnimState(), this.animations.fallingAnimations().mainAnimation(), ageInTicks, this.fallingAnimSpeed());
        } else if (!entity.method_5681()) {
            if (entity.method_5624()) {
                this.animateRunning(entity, limbSwing, limbSwingAmount);
            } else {
                this.animateWalk(entity, limbSwing, limbSwingAmount);
            }
        }
        this.states.getLandAnimState().method_41323(state -> {
            if ((double)state.method_43687() / 1000.0 <= (double)this.animations.fallingAnimations().oppositeAnimation().comp_597()) {
                this.method_43781((class_7094)state, this.animations.fallingAnimations().oppositeAnimation(), ageInTicks);
            } else {
                state.method_41325();
            }
        });
        this.method_43782(this.states.getCrouchAnimState(), this.animations.crouchingAnimations().mainAnimation(), ageInTicks, this.crouchingAnimSpeed());
        this.states.getUncrouchAnimState().method_41323(state -> {
            if ((double)state.method_43687() / 1000.0 <= (double)this.animations.crouchingAnimations().oppositeAnimation().comp_597()) {
                this.method_43782((class_7094)state, this.animations.crouchingAnimations().oppositeAnimation(), ageInTicks, this.crouchingAnimSpeed());
            } else {
                state.method_41325();
            }
        });
        if (!this.isGunLoaded()) {
            this.states.getAttackAnimState().method_41323(state -> {
                class_7184 attackAnim = this.getAttackingAnimation(entity);
                if ((double)state.method_43687() / 1000.0 < (double)attackAnim.comp_597()) {
                    this.method_43781((class_7094)state, attackAnim, ageInTicks);
                } else {
                    state.method_41325();
                }
            });
        }
        if (!this.states.getAttackAnimState().method_41327()) {
            this.method_43781(this.states.getLoadWeaponAnimState(), this.animations.weaponAnimations().mainAnimation(), ageInTicks);
        }
        this.method_43781(this.states.getHideWeaponAnimState(), this.animations.weaponAnimations().oppositeAnimation(), ageInTicks);
        boolean gunLoaded = this.isGunLoaded();
        float gunProcess = this.getGunProcess();
        if (gunLoaded || gunProcess < 1.0f) {
            ArrayList<class_630> list = new ArrayList<class_630>();
            if (this.animations.rightGun()) {
                List<class_630> right = this.getHandDirectory(class_1306.field_6183);
                list.addAll(right.subList(right.indexOf(rightArm), right.size()));
            }
            if (this.animations.leftGun()) {
                List<class_630> left = this.getHandDirectory(class_1306.field_6182);
                list.addAll(left.subList(left.indexOf(leftArm), left.size()));
            }
            float gunLoading = gunLoaded ? 1.0f - gunProcess : gunProcess;
            for (class_630 modelPart : list) {
                class_5603 pose = modelPart.method_41921();
                modelPart.field_3654 = pose.field_27705 + gunLoading * (modelPart.field_3654 - pose.field_27705);
                modelPart.field_3675 = pose.field_27706 + gunLoading * (modelPart.field_3675 - pose.field_27706);
                modelPart.field_3674 = pose.field_27707 + gunLoading * (modelPart.field_3674 - pose.field_27707);
            }
            gunLoading = 1.0f - gunLoading;
            this.positionGun(entity, ageInTicks, netHeadYaw, headPitch, gunLoading);
            gunLoading *= (float)Math.PI / 180;
            if (this.animations.rightGun()) {
                rightArm.field_3674 *= 1.0f - Math.abs(class_3532.method_15393((float)headPitch) / 90.0f);
                rightArm.field_3654 += gunLoading * (class_3532.method_15393((float)headPitch) * class_3532.method_15362((float)rightArm.field_3674) + class_3532.method_15393((float)netHeadYaw) * class_3532.method_15374((float)rightArm.field_3674));
                rightArm.field_3675 += gunLoading * (class_3532.method_15393((float)netHeadYaw) * class_3532.method_15362((float)rightArm.field_3674) - class_3532.method_15393((float)headPitch) * class_3532.method_15374((float)rightArm.field_3674));
            }
            if (this.animations.leftGun()) {
                leftArm.field_3674 *= 1.0f - Math.abs(class_3532.method_15393((float)headPitch) / 90.0f);
                leftArm.field_3654 += gunLoading * (class_3532.method_15393((float)headPitch) * class_3532.method_15362((float)leftArm.field_3674) + class_3532.method_15393((float)netHeadYaw) * class_3532.method_15374((float)leftArm.field_3674));
                leftArm.field_3675 += gunLoading * (class_3532.method_15393((float)netHeadYaw) * class_3532.method_15362((float)leftArm.field_3674) - class_3532.method_15393((float)headPitch) * class_3532.method_15374((float)leftArm.field_3674));
            }
        } else {
            this.positionGun(entity, ageInTicks, netHeadYaw, headPitch, 0.0f);
        }
    }

    public void animateHeadOnLaptop(PlayableTransformer transformer) {
        class_630 head = this.method_2838();
        head.method_32088().forEach(class_630::method_41923);
        head.method_2851(0.0f, 0.0f, 0.0f);
    }

    public void positionGun(T entity, float ageInTicks, float netHeadYaw, float headPitch, float gunLoading) {
        class_7184 anim = this.getAttackingAnimation(entity);
        if (this.isGunLoaded()) {
            if (this.states.getAttackAnimState().method_41327() && (double)this.states.getAttackAnimState().method_43687() / 1000.0 < (double)anim.comp_597()) {
                this.method_43781(this.states.getAttackAnimState(), anim, ageInTicks);
            } else {
                this.states.getAttackAnimState().method_41325();
                this.method_43781(this.states.getLoadGunAnimState(), this.animations.gunAnimations().mainAnimation(), ageInTicks);
            }
        }
        this.method_43781(this.states.getHideGunAnimState(), this.animations.gunAnimations().oppositeAnimation(), ageInTicks);
    }

    public boolean isGunLoaded() {
        return this.states.getLoadGunAnimState().method_41327();
    }

    public boolean isWeaponLoaded() {
        return this.states.getLoadWeaponAnimState().method_41327();
    }

    public float getGunProcess() {
        return class_3532.method_15363((float)(this.states.getLoadGunAnimState().method_41327() ? (float)this.states.getLoadGunAnimState().method_43687() / 1000.0f / this.animations.gunAnimations().mainAnimation().comp_597() : (float)this.states.getHideGunAnimState().method_43687() / 1000.0f / this.animations.gunAnimations().oppositeAnimation().comp_597()), (float)0.0f, (float)1.0f);
    }

    public boolean shouldCancelArmSwinging() {
        return this.isGunLoaded();
    }

    public void setupHandAnim(T entity, float ageInTicks, class_1306 arm) {
        this.method_32008().method_32088().forEach(class_630::method_41923);
        this.method_43781(this.states.getIdleAnimState(), this.animations.idleAnimation(), ageInTicks);
        ArrayList<class_630> parts = new ArrayList<class_630>(this.getHandDirectory(arm));
        parts.remove(parts.size() - 1);
        ArrayDeque deque = new ArrayDeque();
        parts.forEach(modelPart -> deque.addLast(modelPart.method_32084()));
        this.setupHandAnimWithoutChangingPosition(entity, ageInTicks, arm);
        parts.forEach(modelPart -> modelPart.method_32085(Objects.requireNonNull((class_5603)deque.pollFirst())));
        boolean gunLoaded = this.isGunLoaded();
        float gunLoading = this.getGunProcess();
        if (!gunLoaded) {
            gunLoading = 1.0f - gunLoading;
        }
        if (gunLoading > 0.0f) {
            this.positionGunFirstPerson(this.getArm(arm), arm == class_1306.field_6183 ? 1 : -1, gunLoading);
        }
    }

    public void setupHandAnimWithoutChangingPosition(T entity, float ageInTicks, class_1306 arm) {
        class_7184 anim = this.getAttackingAnimation(entity);
        if (this.states.getAttackAnimState().method_41327() && (double)this.states.getAttackAnimState().method_43687() / 1000.0 <= (double)anim.comp_597()) {
            this.method_43781(this.states.getAttackAnimState(), anim, ageInTicks);
        } else {
            this.states.getAttackAnimState().method_41325();
            this.method_43781(this.states.getLoadGunAnimState(), this.animations.gunAnimations().mainAnimation(), ageInTicks);
            this.method_43781(this.states.getLoadWeaponAnimState(), this.animations.weaponAnimations().mainAnimation(), ageInTicks);
        }
        this.method_43781(this.states.getHideGunAnimState(), this.animations.gunAnimations().oppositeAnimation(), ageInTicks);
        this.method_43781(this.states.getHideWeaponAnimState(), this.animations.weaponAnimations().oppositeAnimation(), ageInTicks);
    }

    public void positionGunFirstPerson(class_630 armModel, int handSign, float gunLoadProcess) {
        armModel.method_41920(new Vector3f((float)(handSign * x), (float)y, (float)z).mul(gunLoadProcess));
        armModel.method_41922(new Vector3f((float)xRot, (float)(handSign * yRot), (float)(handSign * zRot)).mul(gunLoadProcess * (float)Math.PI / 180.0f));
    }

    public void renderHand(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, class_1306 arm) {
        this.getArm(arm).method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected float fallingAnimSpeed() {
        return 3.0f;
    }

    protected float crouchingAnimSpeed() {
        return 2.0f;
    }

    public abstract class_630 method_2838();

    public abstract class_630 getArm(class_1306 var1);

    public abstract List<class_630> getHandDirectory(class_1306 var1);

    public abstract class_630 getRightLeg();

    public abstract class_630 getLeftLeg();

    @Override
    protected class_7184 transformAnimation() {
        return this.animations.transformingAnimations().mainAnimation();
    }

    @Override
    protected class_7184 revertAnimation() {
        return this.states.doAFlip() ? this.animations.doAFlip() : this.animations.transformingAnimations().oppositeAnimation();
    }

    protected class_7184 getAttackingAnimation(T player) {
        List<AnimPair> pairs = this.isGunLoaded() ? this.animations.shootingAnimations() : (this.isWeaponLoaded() ? this.animations.weaponAttackingAnimations() : this.animations.attackingAnimations());
        int size = pairs.size();
        AnimPair pair = pairs.get(class_3532.method_15340((int)((int)(this.states.attackAnimIndex() * (float)size)), (int)0, (int)(size - 1)));
        return ((class_1309)player).field_6266 == class_1268.field_5808 == (player.method_6068() == class_1306.field_6183) ? pair.mainAnimation() : pair.oppositeAnimation();
    }

    protected void animateWalk(T entity, float limbSwing, float limbSwingAmount) {
        this.method_48741(this.animations.walkingAnimation(), limbSwing, limbSwingAmount, 1.5f, 1.0f);
    }

    protected void animateRunning(T entity, float limbSwing, float limbSwingAmount) {
        this.animateWalk(entity, limbSwing, limbSwingAmount);
    }
}

