/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.renderer.entity.transformer;

import bnb.tfp.TFPData;
import bnb.tfp.client.model.transformer.AbstractTransformerModel;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.client.renderer.entity.layers.TransformerColorLayers;
import bnb.tfp.client.renderer.entity.layers.TransofrmerPupilsLayer;
import bnb.tfp.client.renderer.entity.transformer.TransformerVehicleRenderer;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_6328;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.minecraft.class_989;

@class_6328
@ParametersAreNonnullByDefault
public class TransformerRenderer<T extends PlayableTransformer, B extends AbstractTransformerBotModel<class_742, T>, V extends AbstractTransformerModel<class_742, T>>
extends class_922<class_742, B> {
    public final TransformerType type;
    @Nullable
    public final TransformerVehicleRenderer<T, V> vehicleRenderer;

    public TransformerRenderer(class_5617.class_5618 ctx, TransformerType type, B model, Function<TransformerRenderer<T, B, V>, TransformerVehicleRenderer<T, V>> vehicleRenderer, float shadowRadius, float pupilSaturation) {
        super(ctx, model, shadowRadius);
        this.type = type;
        this.method_4046((class_3887)new class_989((class_3883)this, ctx.method_43338()));
        this.method_4046(new TransformerColorLayers(this, false));
        if (pupilSaturation != 1.0f) {
            this.method_4046(new TransofrmerPupilsLayer(this, pupilSaturation));
        }
        this.vehicleRenderer = vehicleRenderer.apply(this);
    }

    public TransformerRenderer(class_5617.class_5618 ctx, TransformerType type, B model, V vehicleModel, float shadowRadius, float vehicleShadowRadius, boolean headlights, float pupilSaturation) {
        this(ctx, type, model, renderer -> new TransformerVehicleRenderer(ctx, (AbstractTransformerModel)((Object)vehicleModel), renderer, vehicleShadowRadius, headlights), shadowRadius, pupilSaturation);
    }

    public TransformerRenderer(class_5617.class_5618 ctx, TransformerType type, B model, float shadowRadius, float pupilSaturation) {
        this(ctx, type, model, renderer -> null, shadowRadius, pupilSaturation);
    }

    public boolean setStates(PlayableTransformer transformer) {
        try {
            PlayableTransformer states = transformer;
            ((AbstractTransformerBotModel)this.method_4038()).setStates(states);
            if (this.vehicleRenderer != null) {
                ((AbstractTransformerModel)this.vehicleRenderer.method_4038()).setStates(states);
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void render(class_742 entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 src, int packedLight) {
        PlayableTransformer transformer = TFPData.clientInstance().getTransformer((class_1657)entity);
        if (transformer != null && this.setStates(transformer)) {
            if (this.shouldRenderBotModel(entity, transformer, partialTick)) {
                super.method_4054((class_1309)entity, entityYaw, partialTick, poseStack, src, packedLight);
            }
            if (this.vehicleRenderer != null && this.shouldRenderAltModel(entity, transformer, partialTick)) {
                this.vehicleRenderer.method_4054((class_1309)entity, entityYaw, partialTick, poseStack, src, packedLight);
            }
        }
    }

    protected void setupRotations(class_742 entity, class_4587 poseStack, float ageInTicks, float yRot, float partialTick) {
        super.method_4058((class_1309)entity, poseStack, ageInTicks, yRot, partialTick);
        PlayableTransformer transformer = TFPData.getTransformerStatic((class_1657)entity);
        poseStack.method_22907(transformer.getVehicleType().getRenderRot((class_1657)entity, transformer, class_3532.method_15393((float)(class_3532.method_16439((float)partialTick, (float)entity.field_6259, (float)entity.method_5791()) - yRot)), class_3532.method_15393((float)class_3532.method_16439((float)partialTick, (float)entity.field_6004, (float)entity.method_36455())), partialTick, ((AbstractTransformerBotModel)this.method_4038()).transformationProgress()));
        if (entity.method_20232()) {
            poseStack.method_46416(0.0f, -1.0f, 0.3f);
        }
    }

    public boolean shouldRenderBotModel(class_742 player, PlayableTransformer transformer, float partialTick) {
        return this.vehicleRenderer == null || !transformer.isTransformed() || !((AbstractTransformerBotModel)this.method_4038()).transformationFinished();
    }

    public boolean shouldRenderAltModel(class_742 player, PlayableTransformer transformer, float partialTick) {
        return this.vehicleRenderer != null && (transformer.isTransformed() || !((AbstractTransformerModel)this.vehicleRenderer.method_4038()).transformationFinished());
    }

    public void copyModelProperties(class_591<class_742> model) {
        class_572 humanoidModel = ((AbstractTransformerBotModel)this.method_4038()).humanoidModel;
        humanoidModel.field_3395 = model.field_3395;
        humanoidModel.field_3399 = model.field_3399;
    }

    public boolean shouldCancelArmRendering(class_742 entity, PlayableTransformer transformer, class_1306 arm, float partialTick) {
        return transformer.isTransformed();
    }

    public void setupModelAndRenderArm(class_742 entity, PlayableTransformer transformer, float partialTick, class_4587 poseStack, class_4597 src, int packedLight, class_1306 arm) {
        if (!this.setStates(transformer)) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)this.getTextureLocation(entity));
        ((AbstractTransformerBotModel)this.field_4737).prepareMobModel(entity, 0.0f, 0.0f, partialTick);
        ((AbstractTransformerBotModel)this.field_4737).setupHandAnim(entity, (float)entity.field_6012 + partialTick, arm);
        ((AbstractTransformerBotModel)this.field_4737).renderHand(poseStack, src.getBuffer(((AbstractTransformerBotModel)this.field_4737).method_23500(this.getTextureLocation(entity))), packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f, arm);
        ArrayDeque<TransformerColorLayer> defaultColors = new ArrayDeque<TransformerColorLayer>(transformer.getType().getDefaultVariant());
        for (TransformerColorLayer layer : transformer.getVariant()) {
            class_2960 texture = layer.getTextureLocation((class_1657)entity, transformer, partialTick);
            float[] color = layer.getColor((class_1657)entity, transformer);
            if (layer.shouldRender((class_1657)entity, transformer, false, partialTick) && !Arrays.equals(color, defaultColors.getFirst().getColor((class_1657)entity, transformer))) {
                ((AbstractTransformerBotModel)this.field_4737).renderHand(poseStack, src.getBuffer(class_1921.method_23578((class_2960)texture)), packedLight, class_4608.field_21444, color[0], color[1], color[2], 1.0f, arm);
            }
            if (layer.shouldRenderGlow((class_1657)entity, transformer, false, partialTick)) {
                ((AbstractTransformerBotModel)this.field_4737).renderHand(poseStack, src.getBuffer(class_1921.method_23026((class_2960)texture)), packedLight, class_4608.field_21444, color[0], color[1], color[2], 1.0f, arm);
            }
            defaultColors.poll();
        }
    }

    public void renderArmNoSwing(class_742 player, PlayableTransformer transformer, float partialTick, class_4587 poseStack, class_4597 src, int packedLight, class_1306 arm) {
        boolean flag = arm != class_1306.field_6182;
        float f = flag ? 1.0f : -1.0f;
        poseStack.method_46416(f * 0.64000005f, -0.6f, -0.71999997f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(f * 45.0f));
        poseStack.method_46416(f * -1.0f, 3.6f, 3.5f);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(f * 120.0f));
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(200.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(f * -135.0f));
        poseStack.method_46416(f * 5.6f, 0.0f, 0.0f);
        this.setupModelAndRenderArm(player, transformer, partialTick, poseStack, src, packedLight, arm);
    }

    public class_2960 getTextureLocation(class_742 entity) {
        return new class_2960("tfp", "textures/entity/transformer/" + this.type.getName() + "/original.png");
    }

    public class_2960 getVehicleTextureLocation(class_742 entity) {
        return this.getTextureLocation(entity);
    }

    public boolean shouldHeadlightsGlow(class_742 player, PlayableTransformer transformer, float partialTick) {
        return transformer.isVehicleSpecialActive();
    }

    public class_2960 getHeadlightsTextureLocation(class_742 entity) {
        return new class_2960("tfp", "textures/entity/transformer/" + this.type.getName() + "/headlights.png");
    }
}

