/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.command;

import bnb.tfp.TFPData;
import bnb.tfp.network.ClientboundSetTransformerPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.reg.PlayableTransformers;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerType;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TransformerCommands {
    private static final Predicate<class_2168> HAS_CHEATS = stack -> stack.method_9259(2);
    private static final Predicate<class_2168> IS_OP = stack -> stack.method_9259(3);

    public static void init(Consumer<LiteralArgumentBuilder<class_2168>> register) {
        LiteralArgumentBuilder setSelf = class_2170.method_9247((String)"setself");
        RequiredArgumentBuilder setOthers = class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305());
        PlayableTransformers.getAll().forEach(type -> {
            setSelf.then(class_2170.method_9247((String)type.getName()).executes(ctx -> TransformerCommands.set((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_44023(), type)));
            setOthers.then(class_2170.method_9247((String)type.getName()).executes(ctx -> TransformerCommands.set((class_2168)ctx.getSource(), class_2186.method_9315((CommandContext)ctx, (String)"player"), type)));
        });
        register.accept((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"transformer").requires(HAS_CHEATS)).then((ArgumentBuilder)setSelf)).then(class_2170.method_9247((String)"clearself").executes(ctx -> {
            class_2168 src = (class_2168)ctx.getSource();
            class_3222 player = Objects.requireNonNull(src.method_44023());
            return TransformerCommands.clear((class_2168)ctx.getSource(), player.method_5820(), player);
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(IS_OP)).then((ArgumentBuilder)setOthers))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(IS_OP)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> TransformerCommands.clear((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), null))))));
    }

    private static int clear(class_2168 src, String name, @Nullable class_3222 player) {
        class_3222 player1;
        UUID uuid;
        MinecraftServer server = src.method_9211();
        if (player != null) {
            uuid = player.method_5667();
        } else {
            try {
                uuid = ((GameProfile)server.method_3793().method_14515(name).get()).getId();
            }
            catch (NullPointerException | NoSuchElementException e) {
                src.method_9213((class_2561)class_2561.method_43471((String)"command.failed"));
                return 0;
            }
        }
        TFPData tfpData = TFPData.serverInstance(server);
        PlayableTransformer transformer = tfpData.getTransformer(uuid);
        if (transformer == null) {
            src.method_9213((class_2561)class_2561.method_43471((String)"commands.tfp.transformer.clear.notATransformer"));
            return 0;
        }
        tfpData.clearTransformer(uuid);
        class_3222 class_32222 = player1 = player != null ? player : server.method_3760().method_14566(name);
        if (player1 != null) {
            transformer.onTurnedIntoHuman((class_1657)player1);
        }
        ModNetworking.sendToEveryone(server, new ClientboundSetTransformerPacket(uuid));
        src.method_9226(() -> class_2561.method_43469((String)"commands.tfp.transformer.clear.success", (Object[])new Object[]{name, transformer.getNameComponent()}), true);
        return 1;
    }

    private static int set(class_2168 src, class_3222 player, TransformerType type) {
        TFPData tfpData = TFPData.serverInstance(src.method_9211());
        PlayableTransformer before = tfpData.getTransformer((class_1657)player);
        if (before != null && before.getType() == type) {
            src.method_9213((class_2561)class_2561.method_43469((String)"commands.tfp.transformer.set.alreadyThatTransformer", (Object[])new Object[]{before.getNameComponent()}));
            return 0;
        }
        PlayableTransformer transformer = type.get();
        if (!TransformerCommands.trySetTransformer((class_1657)player, tfpData, transformer)) {
            src.method_9213((class_2561)class_2561.method_43469((String)"commands.tfp.transformer.set.noAvailable", (Object[])new Object[]{transformer.getNameComponent()}));
            return 0;
        }
        transformer.setupTransformer(player);
        ModNetworking.sendToEveryone(src.method_9211(), new ClientboundSetTransformerPacket(player.method_5667(), transformer));
        src.method_9226(() -> class_2561.method_43469((String)"commands.tfp.transformer.set.success", (Object[])new Object[]{player.method_5477(), transformer.getNameComponent()}), true);
        return 1;
    }

    public static boolean trySetTransformer(class_1657 player, TFPData tfpData, PlayableTransformer transformer) {
        return TransformerCommands.trySetTransformer(player.method_5667(), tfpData, transformer);
    }

    public static boolean trySetTransformer(UUID uuid, TFPData tfpData, PlayableTransformer transformer) {
        return TransformerCommands.trySetTransformer(uuid, tfpData, transformer, transformer.getVariant().size() - 1);
    }

    private static boolean trySetTransformer(UUID uuid, TFPData tfpData, PlayableTransformer transformer, int index) {
        if (index < 0) {
            return tfpData.setTransformer(uuid, transformer);
        }
        TransformerColorLayer layer = transformer.getVariant().get(index);
        for (int i = 0; i < (layer.brightColorsOnly() ? 216 : 1728); ++i) {
            if (TransformerCommands.trySetTransformer(uuid, tfpData, transformer, index - 1)) {
                return true;
            }
            HSBColor color = layer.getColor();
            int hue = color.hue;
            int saturation = color.saturation;
            int brightness = color.brightness;
            if (++hue < 24) {
                layer.setColor(new HSBColor(hue, saturation, brightness));
                continue;
            }
            if (--saturation >= 0) {
                layer.setColor(new HSBColor(0, saturation, brightness));
                continue;
            }
            if (!layer.brightColorsOnly() && --brightness > 0) {
                layer.setColor(new HSBColor(0, 8, brightness));
                continue;
            }
            layer.setColor(new HSBColor(0, 8, 8));
        }
        return false;
    }
}

