/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.levelgen.feature;

import bnb.tfp.block.EnergonCrystalBlock;
import bnb.tfp.levelgen.feature.configuration.EnergonDepositConfiguration;
import bnb.tfp.reg.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class EnergonDepositFeature
extends class_3031<EnergonDepositConfiguration> {
    private static final class_2680 AIR = class_2246.field_10543.method_9564();
    private static final class_2680 BUDDING = ModBlocks.BUDDING_ENERGON.get().method_9564();
    private static final class_2680 CYBERMATTER = ModBlocks.CYBERMATTER.get().method_9564();
    private static final class_2350[] DIRECTIONS = class_2350.values();

    public EnergonDepositFeature(Codec<EnergonDepositConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<EnergonDepositConfiguration> ctx) {
        class_2338 origin;
        class_5281 lvl = ctx.method_33652();
        if (lvl.method_31606(origin = ctx.method_33655())) {
            return false;
        }
        EnergonDepositConfiguration config = (EnergonDepositConfiguration)ctx.method_33656();
        class_5819 random = ctx.method_33654();
        float radius = config.segmentRadius().method_33920(random);
        ArrayList<class_2338> centers = new ArrayList<class_2338>();
        for (int i = config.segmentsAmount().method_35008(random); i > 0; --i) {
            centers.add(new class_2338((int)random.method_43385((double)origin.method_10263(), (double)(radius * 2.0f - 2.0f)), (int)random.method_43385((double)origin.method_10264(), (double)(radius * 2.0f - 2.0f)), (int)random.method_43385((double)origin.method_10260(), (double)(radius * 2.0f - 2.0f))));
        }
        boolean[] impossibleToPlace = new boolean[]{false, true};
        EnergonDepositFeature.applyToAllBlocksCloseEnough(centers, radius + 1.0f, (pos, distance) -> {
            if (impossibleToPlace[0]) {
                return;
            }
            class_2680 state = lvl.method_8320(pos);
            if (!state.method_26227().method_15769()) {
                impossibleToPlace[0] = true;
            } else if (!state.method_26215()) {
                impossibleToPlace[1] = false;
            }
        });
        if (impossibleToPlace[0] || impossibleToPlace[1]) {
            return false;
        }
        EnergonDepositFeature.applyToAllBlocksCloseEnough(centers, radius, (pos, distance) -> lvl.method_8652(pos, AIR, 3));
        float f0 = config.buddingEnergonChance();
        boolean b0 = config.buddingEnergonChance() > 0.0f;
        float f1 = f0 + config.cybermatterChance();
        boolean b1 = config.cybermatterChance() > 0.0f;
        float f2 = f1 + config.crystalChance();
        class_4651 crystalProvider = config.crystalProvider();
        EnergonDepositFeature.applyToAllBlocksCloseEnough(centers, radius + 1.0f, (pos, distance) -> {
            block5: {
                float f3;
                block6: {
                    block4: {
                        if (distance < (double)radius || lvl.method_31606(pos)) {
                            return;
                        }
                        class_2680 state = lvl.method_8320(pos);
                        if (state.method_26215() || state.method_26164(ModBlocks.ENERGONS)) {
                            return;
                        }
                        f3 = random.method_43057();
                        if (!b0 || !(f3 < f0)) break block4;
                        this.method_13153((class_1945)lvl, (class_2338)pos, BUDDING);
                        for (class_2350 direction : DIRECTIONS) {
                            if (!(random.method_43057() < f2)) continue;
                            EnergonCrystalBlock.tryPlaceOnBLock(crystalProvider.method_23455(random, pos), lvl, pos, direction, random);
                        }
                        break block5;
                    }
                    if (!b1 || !(f3 < f1)) break block6;
                    this.method_13153((class_1945)lvl, (class_2338)pos, CYBERMATTER);
                    break block5;
                }
                if (!(f3 < f2)) break block5;
                for (class_2350 direction : class_2350.method_42014((class_5819)random)) {
                    if (!EnergonCrystalBlock.tryPlaceOnBLock(crystalProvider.method_23455(random, pos), lvl, pos, direction, random)) continue;
                    return;
                }
            }
        });
        return true;
    }

    private static void applyToAllBlocksCloseEnough(List<class_2338> centers, float radius, BiConsumer<class_2338, Double> action) {
        for (class_2338 pos : centers) {
            class_243 center = pos.method_46558();
            int intRadius = (int)radius;
            for (int x = pos.method_10263() - intRadius; x <= pos.method_10263() + intRadius; ++x) {
                for (int y = pos.method_10264() - intRadius; y <= pos.method_10264() + intRadius; ++y) {
                    for (int z = pos.method_10260() - intRadius; z <= pos.method_10260() + intRadius; ++z) {
                        class_2338 pos1 = new class_2338(x, y, z);
                        double distance = center.method_1022(pos1.method_46558());
                        if (!(distance <= (double)radius)) continue;
                        action.accept(pos1, distance);
                    }
                }
            }
        }
    }
}

