/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.network;

import bnb.tfp.TFPData;
import bnb.tfp.network.ClientboundTransformerActionPacket;
import bnb.tfp.network.ModServerboundPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerSounds;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class TransformerActionPacket
implements ModServerboundPacket {
    private final Action action;

    public TransformerActionPacket(Action action) {
        this.action = action;
    }

    public TransformerActionPacket(class_2540 buf) {
        this((Action)buf.method_10818(Action.class));
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10817((Enum)this.action);
    }

    @Override
    public void handle(class_3222 sender) {
        class_3218 lvl = sender.method_51469();
        TFPData tfpData = TFPData.serverInstance(Objects.requireNonNull(sender.method_5682()));
        PlayableTransformer transformer = tfpData.getTransformer((class_1657)sender);
        if (transformer == null) {
            return;
        }
        Optional<class_3414> optional = Optional.empty();
        switch (this.action) {
            case TRANSFORM: {
                transformer.transform((class_1937)lvl, (class_1657)sender);
                break;
            }
            case WEAPON: {
                boolean value = !transformer.isUsingWeapon();
                optional = transformer.getSounds().getSound(value ? TransformerSounds.Sound.EQUIP_WEAPON : TransformerSounds.Sound.HIDE_WEAPON);
                transformer.equipWeapon((class_1657)sender, value);
                break;
            }
            case GUN: {
                boolean value = !transformer.isGunLoaded();
                optional = transformer.getSounds().getSound(value ? TransformerSounds.Sound.EQUIP_GUN : TransformerSounds.Sound.HIDE_GUN);
                transformer.equipGun((class_1657)sender, value);
                break;
            }
            case SPECIAL: {
                transformer.useSpecial((class_1937)lvl, (class_1657)sender);
            }
        }
        optional.ifPresent(soundEvent -> sender.method_37908().method_43129(null, (class_1297)sender, soundEvent, class_3419.field_15248, 1.0f, 0.9f + sender.method_6051().method_43057() * 0.2f));
        ModNetworking.sendToEveryone(sender.field_13995, new ClientboundTransformerActionPacket(sender.method_5667(), this.action));
    }

    public static enum Action {
        TRANSFORM,
        WEAPON,
        GUN,
        SPECIAL;

    }
}

