/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.TFPUtils;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerType;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_6328;
import net.minecraft.class_7094;

@class_6328
@ParametersAreNonnullByDefault
public class Airachnid
extends PlayableTransformer {
    private static final class_4048 SPIDER_DIMENSIONS = class_4048.method_18384((float)2.8f, (float)3.2f);
    private static final class_1322 SPIDER_SPEED_MODIFIER = new class_1322(TFPUtils.TRANSFORMER_MODIFIERS_UUID, "Airachnid spider modifier", 0.05, class_1322.class_1323.field_6328);
    public final class_7094 spiderAnimState = new class_7094();

    public Airachnid(TransformerType type) {
        super(type);
    }

    public class_7094 getSpiderAnimState() {
        return this.spiderAnimState;
    }

    @Override
    public void resetAnimStates(@Nullable class_1657 player) {
        super.resetAnimStates(player);
        this.spiderAnimState.method_41322(Integer.MIN_VALUE);
    }

    @Override
    public class_4048 makeDimensions(class_1657 player, class_4050 pose) {
        return this.isSpecialActive() ? SPIDER_DIMENSIONS : super.makeDimensions(player, pose);
    }

    @Override
    public void tick(class_1657 player) {
        super.tick(player);
        class_1324 instance = Objects.requireNonNull(player.method_5996(class_5134.field_23719));
        if (this.isSpecialActive()) {
            if (!instance.method_6196(SPIDER_SPEED_MODIFIER)) {
                instance.method_26837(SPIDER_SPEED_MODIFIER);
            }
        } else {
            instance.method_6200(TFPUtils.TRANSFORMER_MODIFIERS_UUID);
        }
    }

    @Override
    public boolean transform(class_1937 lvl, @Nullable class_1657 player) {
        if (player != null && (this.isSpecialActive() || !this.isTransformed() && player.method_18276())) {
            this.setSpecialActive(!this.isSpecialActive());
            player.method_18382();
            this.getSpiderAnimState().method_41322(player.field_6012);
            return true;
        }
        return super.transform(lvl, player);
    }

    @Override
    public boolean canUseWeapon(class_1657 player) {
        return !this.isSpecialActive() && super.canUseWeapon(player);
    }

    @Override
    public boolean isUsingWeapon(class_1657 player) {
        return this.isSpecialActive() && !this.isGunLoaded() && player.method_6047().method_7960() || super.isUsingWeapon(player);
    }

    @Override
    public boolean beforeHit(class_1657 attacker, class_1297 target) {
        if (super.beforeHit(attacker, target)) {
            return true;
        }
        if (this.isUsingWeapon(attacker)) {
            double damage = this.getType().getWeaponDamage();
            if (target instanceof class_1309) {
                class_1293 instance;
                class_1309 living = (class_1309)target;
                if (this.isUsingWeapon(attacker) && (instance = living.method_6112(class_1294.field_5909)) != null) {
                    damage += (double)((instance.method_5578() + 1) * 3);
                }
            }
            class_1324 attribute = Objects.requireNonNull(attacker.method_5996(class_5134.field_23721));
            attribute.method_6200(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID);
            attribute.method_26835(new class_1322(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID, "Transformer weapon modifier", damage, class_1322.class_1323.field_6328));
        }
        return false;
    }

    @Override
    public void shoot(class_1657 player, class_1937 lvl) {
        if (this.isSpecialActive()) {
            lvl.method_8649((class_1297)TFPUtils.createAndShootProjectile(lvl, ModEntities.COBWEB_PROJECTILE.get(), player, 2.0f, 1.0f, true));
            if (!player.method_31549().field_7480 && player.method_6051().method_43048(4) == 0) {
                player.method_7344().method_7585(-1, 0.0f);
            }
            lvl.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_28565, class_3419.field_15248, 1.0f, 0.8f + player.method_6051().method_43057() * 0.4f);
            return;
        }
        super.shoot(player, lvl);
    }

    @Override
    public float getDestroySpeedCoef(class_1657 player, class_2680 state) {
        return this.isUsingWeapon(player) && state.method_27852(class_2246.field_10343) ? 100.0f : super.getDestroySpeedCoef(player, state);
    }
}

