/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import net.minecraft.class_3532;

public class HSBColor {
    public final int hue;
    public final int saturation;
    public final int brightness;
    public final float red;
    public final float green;
    public final float blue;
    public final int argb;

    public HSBColor(int hue, int saturation, int brightness) {
        this.brightness = class_3532.method_15340((int)brightness, (int)1, (int)8);
        if (hue >= 0 && hue <= 23 && saturation >= 1 && saturation <= 8) {
            this.hue = hue;
            this.saturation = saturation;
            float f0 = (float)saturation / 8.0f;
            float f1 = (float)brightness / 32.0f;
            this.red = class_3532.method_16439((float)f0, (float)4.0f, (float)(hue <= 8 ? (float)Math.min(8 - hue, 4) : (hue <= 16 ? 0.0f : (float)Math.min(hue - 16, 4)))) * f1;
            this.green = class_3532.method_16439((float)f0, (float)4.0f, (float)class_3532.method_15340((int)(8 - Math.abs(hue - 8)), (int)0, (int)4)) * f1;
            this.blue = class_3532.method_16439((float)f0, (float)4.0f, (float)class_3532.method_15340((int)(8 - Math.abs(hue - 16)), (int)0, (int)4)) * f1;
        } else {
            this.hue = 31;
            this.saturation = 0;
            this.green = this.blue = (float)brightness / 8.0f;
            this.red = this.blue;
        }
        this.argb = ((int)(this.red * 255.0f) << 16) + ((int)(this.green * 255.0f) << 8) + (int)(this.blue * 255.0f) - 0x1000000;
    }

    public static HSBColor fromShort(short s) {
        return new HSBColor(s >> 6, (s >> 3) % 8 + 1, s % 8 + 1);
    }

    public short toShort() {
        return (short)((this.hue << 6) + (this.saturation - 1 << 3) + this.brightness - 1);
    }

    public float[] rgbFloats() {
        return new float[]{this.red, this.green, this.blue};
    }

    public HSBColor copyWithBrightness(int brightness) {
        return new HSBColor(this.hue, this.saturation, brightness);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof HSBColor)) return false;
        HSBColor color = (HSBColor)obj;
        if (obj.getClass() != this.getClass()) return false;
        if (this.hue != color.hue) return false;
        if (this.saturation != color.saturation) return false;
        if (this.brightness != color.brightness) return false;
        return true;
    }

    public static void main(String[] args) {
        System.out.println(new HSBColor(15, 3, 4).toShort());
    }
}

