/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.TFPData;
import bnb.tfp.TFPUtils;
import bnb.tfp.client.ClientUtils;
import bnb.tfp.entity.ModProjectiles;
import bnb.tfp.entity.TransformerAnimatable;
import bnb.tfp.item.TransformerArmorItem;
import bnb.tfp.network.ClientboundVampireTerrorconPacket;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.reg.ModItems;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.reg.ModSounds;
import bnb.tfp.reg.PlayableTransformers;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.TransformerColorLayer;
import bnb.tfp.transformer.TransformerSounds;
import bnb.tfp.transformer.TransformerType;
import bnb.tfp.transformer.vehicletypes.VehicleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2516;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2752;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5135;
import net.minecraft.class_5146;
import net.minecraft.class_6328;
import net.minecraft.class_7094;
import net.minecraft.class_7923;

@class_6328
@ParametersAreNonnullByDefault
public class PlayableTransformer
implements TransformerAnimatable {
    private final TransformerType type;
    private Faction faction;
    private final ArrayList<TransformerColorLayer> variant;
    private boolean transformed;
    private double transformedTick;
    private boolean gun;
    private boolean weapon;
    private boolean specialActive;
    private boolean vehicleSpecialActive;
    private boolean dirty;
    private int passengers;
    private byte passengersLimit;
    private boolean minerMode;
    private int darkEnergonExposure;
    private boolean vampire;
    private boolean f5Vehicle;
    public boolean settled;
    private boolean doAFlip;
    public boolean crouching;
    public boolean playFallAnim;
    public float attackAnimIndex;
    private final class_7094 transformAnimState = new class_7094();
    private final class_7094 revertAnimState = new class_7094();
    private final class_7094 settleAnimState = new class_7094();
    private final class_7094 attackAnimState = new class_7094();
    private final class_7094 idleAnimState = new class_7094();
    private final class_7094 crouchAnimState = new class_7094();
    private final class_7094 uncrouchAnimState = new class_7094();
    private final class_7094 loadGunAnimState = new class_7094();
    private final class_7094 hideGunAnimState = new class_7094();
    private final class_7094 loadWeaponAnimState = new class_7094();
    private final class_7094 hideWeaponAnimState = new class_7094();
    private final class_7094 fallAnimState = new class_7094();
    private final class_7094 landAnimState = new class_7094();

    public PlayableTransformer(TransformerType type) {
        this.type = type;
        this.faction = type.getFaction();
        this.variant = new ArrayList<TransformerColorLayer>(type.getDefaultVariant());
        this.passengersLimit = type.getDefaultPassengers();
    }

    public final TransformerType getType() {
        return this.type;
    }

    public TransformerSounds getSounds() {
        return this.getType().getSounds();
    }

    public VehicleType getVehicleType() {
        return this.getType().getVehicleType();
    }

    public class_2561 getNameComponent() {
        return class_2561.method_43471((String)("transformer.tfp." + this.getType().getName())).method_27692(this.getFaction().color);
    }

    public class_4048 makeDimensions(class_1657 player, class_4050 pose) {
        class_4048 output = this.getType().getDimensions();
        if (this.transformed) {
            output = this.getType().getAltDimensions();
        } else {
            switch (pose) {
                case field_18081: {
                    output = class_4048.method_18384((float)output.field_18067, (float)(output.field_18068 * 0.75f));
                    break;
                }
                case field_18079: {
                    output = class_4048.method_18384((float)output.field_18067, (float)output.field_18067);
                }
            }
        }
        return output;
    }

    public float getEyeHeight(class_1657 player, class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.85f;
    }

    public Faction getFaction() {
        return this.faction;
    }

    public void setFaction(Faction faction) {
        this.faction = faction;
    }

    public List<TransformerColorLayer> getVariant() {
        return List.copyOf(this.variant);
    }

    public List<HSBColor> getColors() {
        return this.getVariant().stream().map(TransformerColorLayer::getColor).toList();
    }

    public void setColor(int index, HSBColor value) {
        this.variant.get(index).setColor(value);
    }

    public float[] getGlowingColor(class_1657 player) {
        return this.variant.isEmpty() ? (this.isVampire() ? TransformerColorLayer.VAMPIRE_RGB : (this.onDarkEnergon() ? TransformerColorLayer.DARK_ENERGON_RGB : (this.onSynthEn() ? TransformerColorLayer.SYNTH_EN_RGB : this.faction.defaultGlowRGB))) : this.variant.get(this.variant.size() - 1).getColor(player, this);
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public void setTransformed(boolean transformed) {
        this.transformed = transformed;
        this.setDirty(true);
    }

    public double getTransformedTick() {
        return this.transformedTick;
    }

    public void setTransformedTick(double transformedTick) {
        this.transformedTick = transformedTick;
    }

    public boolean transform(class_1937 lvl, @Nullable class_1657 player) {
        boolean output = !this.isTransformed();
        this.setTransformed(output);
        this.setTransformedTick(lvl.method_8510());
        if (player != null) {
            player.method_18382();
            player.method_5772();
            if (lvl.field_9236) {
                ClientUtils.playTransformerEngineSound(this, player);
            } else {
                this.getSounds().getSound(this.transformed ? TransformerSounds.Sound.TRANSFORM : TransformerSounds.Sound.REVERT).ifPresent(soundEvent -> lvl.method_43129(null, (class_1297)player, soundEvent, class_3419.field_15248, 1.0f, 0.9f + player.method_6051().method_43057() * 0.2f));
            }
            if (this.isTransformed()) {
                this.revertAnimState.method_41325();
                this.transformAnimState.method_41322(player.field_6012);
            } else {
                this.transformAnimState.method_41325();
                this.revertAnimState.method_41322(player.field_6012);
                this.doAFlip = this.getVehicleType().shouldDoAFlip(player, this);
                this.settled = false;
                this.settleAnimState.method_41322(Integer.MAX_VALUE);
            }
            this.hideGunAnimState.method_41322(Integer.MIN_VALUE);
            this.hideWeaponAnimState.method_41322(Integer.MIN_VALUE);
            this.landAnimState.method_41322(Integer.MIN_VALUE);
        }
        return output;
    }

    public boolean canUseWeapon(class_1657 player) {
        return this.getType().hasWeapon() && player.method_6047().method_7960() && !this.transformed;
    }

    public boolean isUsingWeapon() {
        return this.weapon;
    }

    public boolean isUsingWeapon(class_1657 player) {
        return this.isUsingWeapon();
    }

    public void setUsingWeapon(boolean value) {
        if (this.weapon != value) {
            this.weapon = value;
            this.setDirty(true);
        }
    }

    public void equipWeapon(@Nullable class_1657 player, boolean value) {
        int tickCount;
        int n = tickCount = player != null ? player.field_6012 : Integer.MIN_VALUE;
        if (this.isGunLoaded()) {
            this.setGunLoaded(false);
            this.getLoadGunAnimState().method_41325();
            this.getHideGunAnimState().method_41322(tickCount);
        }
        if (value) {
            this.setUsingWeapon(true);
            this.getHideWeaponAnimState().method_41325();
            this.getLoadWeaponAnimState().method_41322(tickCount);
        } else {
            this.setUsingWeapon(false);
            this.getLoadWeaponAnimState().method_41325();
            this.getHideWeaponAnimState().method_41322(tickCount);
        }
    }

    public Map<class_1320, Double> getWeaponModifiers() {
        HashMap<class_1320, Double> hashMap = new HashMap<class_1320, Double>();
        if (this.getType().getWeaponDamage() != 0.0) {
            hashMap.put(class_5134.field_23721, this.getType().getWeaponDamage());
        }
        if (this.getType().getWeaponSpeed() != 0.0) {
            hashMap.put(class_5134.field_23723, this.getType().getWeaponSpeed());
        }
        return Map.copyOf(hashMap);
    }

    public boolean beforeHit(class_1657 attacker, class_1297 target) {
        return false;
    }

    public void onHit(class_1657 attacker, class_1297 target) {
        if (!this.isVampire() || !(target instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)target;
        PlayableTransformer transformer = TFPData.getTransformerStatic(player);
        if (transformer == null || transformer.isVampire()) {
            return;
        }
        attacker.method_7344().method_7585(20, 0.5f);
        if ((double)attacker.method_6051().method_43057() < 0.0625) {
            transformer.setVampire(true);
        }
    }

    public boolean canUseGun(class_1657 player) {
        return !this.transformed && this.getType().hasGun() && player.method_6047().method_7960() && (player.method_31549().field_7480 || player.method_7344().method_7586() > 4);
    }

    @Override
    public boolean doAFlip() {
        return this.doAFlip;
    }

    public boolean isGunLoaded() {
        return this.gun;
    }

    public boolean isUsingGun(class_1657 player) {
        return this.isGunLoaded() || this.isTransformed() && this.getType().hasGun() && player.method_6047().method_7960() && (player.method_31549().field_7480 || player.method_7344().method_7586() > 4);
    }

    public void setGunLoaded(boolean value) {
        if (this.gun != value) {
            this.gun = value;
            this.setDirty(true);
        }
    }

    public void equipGun(@Nullable class_1657 player, boolean value) {
        int tickCount;
        int n = tickCount = player != null ? player.field_6012 : Integer.MIN_VALUE;
        if (this.isUsingWeapon()) {
            this.setUsingWeapon(false);
            this.getLoadWeaponAnimState().method_41325();
            this.getHideWeaponAnimState().method_41322(tickCount);
        }
        if (value) {
            this.setGunLoaded(true);
            this.getHideGunAnimState().method_41325();
            this.getLoadGunAnimState().method_41322(tickCount);
        } else {
            this.setGunLoaded(false);
            this.getLoadGunAnimState().method_41325();
            this.getHideGunAnimState().method_41322(tickCount);
        }
    }

    public void swing(class_1657 player) {
        class_1937 lvl = player.method_37908();
        if (lvl.field_9236) {
            return;
        }
        if (player.method_7261(0.5f) > 0.9f && this.isUsingGun(player)) {
            this.shoot(player, lvl);
        }
    }

    public void shoot(class_1657 player, class_1937 lvl) {
        class_1676 projectile = TFPUtils.createAndShootProjectile(lvl, ModEntities.ION_BULLET.get(), player, 3.0f, 0.0f, false);
        if (projectile instanceof ModProjectiles.IonBullet) {
            ModProjectiles.IonBullet bullet = (ModProjectiles.IonBullet)projectile;
            bullet.setDamage(this.getType().getGunDamage());
            bullet.setColor(this.getGlowingColor(player));
        }
        lvl.method_8649((class_1297)projectile);
        if (!player.method_31549().field_7480 && player.method_6051().method_43048(4) == 0) {
            player.method_7344().method_7585(-1, 0.0f);
        }
        this.getSounds().getSound(TransformerSounds.Sound.SHOOT).ifPresent(soundEvent -> lvl.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), soundEvent, class_3419.field_15248, 1.0f, 1.0f));
    }

    @Nullable
    public class_1322 getShootingSpeedModifier(class_1657 player) {
        return this.getType().getGunSpeed() != 0.0 ? new class_1322(TFPUtils.TRANSFORMER_GUN_MODIFIERS_UUID, "Transformer gun modifier", this.getType().getGunSpeed(), class_1322.class_1323.field_6328) : null;
    }

    public boolean getF5Vehicle() {
        return this.f5Vehicle;
    }

    public void setF5Vehicle(boolean Boolean2) {
        this.f5Vehicle = Boolean2;
        this.setDirty(true);
    }

    public double getBlockReach(class_1657 player) {
        return 7.0;
    }

    public double getEntityReach(class_1657 player) {
        return 5.0;
    }

    public boolean isSpecialActive() {
        return this.specialActive;
    }

    public boolean isVehicleSpecialActive() {
        return this.vehicleSpecialActive;
    }

    public void setSpecialActive(boolean specialActive) {
        this.specialActive = specialActive;
        this.setDirty(true);
    }

    public void setVehicleSpecialActive(boolean vehicleSpecialActive) {
        this.vehicleSpecialActive = vehicleSpecialActive;
        this.setDirty(true);
    }

    public boolean canUseSpecial(class_1657 player) {
        return this.isTransformed() ? this.getType().canVehicleUseSpecial() : this.getType().canBotUseSpecial();
    }

    public void useSpecial(class_1937 lvl, @Nullable class_1657 player) {
        if (this.transformed) {
            this.setVehicleSpecialActive(!this.isVehicleSpecialActive());
            if (player != null) {
                lvl.method_43129(null, (class_1297)player, ModSounds.HEADLIGHTS.get(), class_3419.field_15248, 1.0f, 0.8f + player.method_6051().method_43057() * 0.4f);
            }
        } else {
            this.setSpecialActive(!this.isSpecialActive());
        }
    }

    public boolean isMinerMode() {
        return this.minerMode;
    }

    public void setMinerMode(boolean minerMode) {
        this.minerMode = minerMode;
    }

    public int getDarkEnergonExposure() {
        return this.darkEnergonExposure;
    }

    public boolean onDarkEnergon() {
        return this.darkEnergonExposure > 0;
    }

    public boolean onSynthEn() {
        return this.darkEnergonExposure < 0;
    }

    public void addDarkEnergonExposure(int addDarkEnergon) {
        this.darkEnergonExposure += addDarkEnergon;
        this.setDirty(true);
    }

    public void setDarkEnergonExposure(int setDarkEnergon) {
        this.darkEnergonExposure = setDarkEnergon;
        this.setDirty(true);
    }

    public boolean isVampire() {
        return this.vampire;
    }

    public void setVampire(boolean vampire) {
        if (this.vampire != vampire) {
            this.vampire = vampire;
            this.setDirty(true);
        }
    }

    public byte getPassengersLimit() {
        return this.passengersLimit;
    }

    public void setPassengersLimit(int value) {
        this.passengersLimit = (byte)class_3532.method_15340((int)0, (int)value, (int)this.getType().getMaxPassengers());
    }

    public Map<class_1320, Double> getAttributeValues() {
        return Map.of(class_5134.field_23716, this.getType().getHealth());
    }

    public float getMaxUpStep(class_1657 player) {
        return 1.0f;
    }

    public float getJumpPowerCoef(class_1657 player) {
        return 1.5f;
    }

    public float getDestroySpeedCoef(class_1657 player, class_2680 state) {
        return 1.0f;
    }

    public boolean canHarvest(class_1657 player, class_2680 state) {
        return false;
    }

    public void tick(class_1657 player) {
        class_1322 modifier;
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof class_5146 || vehicle instanceof class_1690 || vehicle instanceof class_1695) {
            player.method_33567(player.method_23317(), player.method_23318() + 1.0, player.method_23321());
        }
        if (this.isUsingWeapon() && !this.canUseWeapon(player)) {
            this.equipWeapon(player, false);
        }
        if (this.isGunLoaded() && !this.canUseGun(player)) {
            this.equipGun(player, false);
        }
        if ((modifier = this.getShootingSpeedModifier(player)) != null) {
            class_1324 speed = Objects.requireNonNull(player.method_5996(class_5134.field_23723));
            boolean b0 = this.isUsingGun(player);
            boolean b1 = speed.method_6196(modifier);
            if (b0 && !b1) {
                speed.method_26835(modifier);
            } else if (!b0 && b1) {
                speed.method_6202(modifier);
            }
        }
        boolean b2 = this.isUsingWeapon(player);
        Map<class_1320, Double> modifiers = this.getWeaponModifiers();
        modifiers.forEach((attribute, value) -> {
            class_1324 instance = Objects.requireNonNull(player.method_5996(attribute));
            class_1322 modifier1 = new class_1322(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID, "Transformer weapon modifier", value.doubleValue(), class_1322.class_1323.field_6328);
            boolean b3 = instance.method_6196(modifier1);
            if (b2 && !b3) {
                instance.method_26835(modifier1);
            } else if (!b2 && b3) {
                instance.method_6202(modifier1);
            }
        });
        if (player.method_37908().field_9236) {
            if (player.field_6012 <= 1) {
                this.resetAnimStates(player);
            }
            this.setupAnimStates(player);
        }
    }

    public void tryUpdatePassengers(class_1657 player) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 lvl = (class_3218)class_19372;
        int newPassengers = player.method_5685().size();
        if (this.passengers == newPassengers) {
            return;
        }
        this.passengers = newPassengers;
        lvl.method_18456().forEach(player1 -> player1.field_13987.method_14364((class_2596)new class_2752((class_1297)player)));
    }

    public void setupTransformer(class_3222 player) {
        if (this.isVampire()) {
            this.setVampire(false);
            ModNetworking.send(player, new ClientboundVampireTerrorconPacket(player.method_5667(), false));
        }
        ModItems.TransformerArmor armor = this.getFaction().armor;
        class_1799 helmet = new class_1799((class_1935)armor.getHelmet());
        class_1799 chestplate = new class_1799((class_1935)armor.getChestplate());
        class_1799 leggings = new class_1799((class_1935)armor.getLeggings());
        class_1799 boots = new class_1799((class_1935)armor.getBoots());
        for (class_1799 i : new class_1799[]{helmet, chestplate, leggings, boots}) {
            i.method_7978(class_1893.field_9113, 1);
            i.method_7978(class_1893.field_9109, 1);
            class_1304 slot = class_1308.method_32326((class_1799)i);
            class_1799 replaced = player.method_6118(slot).method_51164();
            player.method_5673(slot, i);
            if (replaced.method_7909() instanceof TransformerArmorItem) continue;
            player.method_7270(replaced);
        }
        float oMaxHealth = player.method_6063();
        Map<class_1320, Double> map = this.getAttributeValues();
        for (class_1320 attr : class_7923.field_41190) {
            class_1324 instance = player.method_5996(attr);
            if (instance == null) continue;
            instance.method_6200(TFPUtils.TRANSFORMER_MODIFIERS_UUID);
            instance.method_6200(TFPUtils.TRANSFORMER_GUN_MODIFIERS_UUID);
            instance.method_6200(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID);
            if (!map.containsKey(attr)) continue;
            instance.method_6192(map.get(attr).doubleValue());
        }
        if (player.method_6032() > player.method_6063()) {
            player.method_6033(player.method_6063());
        }
        player.method_6025(player.method_6063() - oMaxHealth);
        TFPUtils.setReach.accept((Object)player, (Object)this.getBlockReach((class_1657)player), (Object)this.getEntityReach((class_1657)player));
        player.method_18382();
    }

    public void onTurnedIntoHuman(class_1657 player) {
        player.method_5661().forEach(stack -> stack.method_7939(0));
        class_5132 sup = class_5135.method_26873((class_1299)class_1299.field_6097);
        for (class_1320 attr : class_7923.field_41190) {
            class_1324 instance = player.method_5996(attr);
            if (instance == null) continue;
            instance.method_6192(sup.method_26864(attr));
            instance.method_6200(TFPUtils.TRANSFORMER_MODIFIERS_UUID);
            instance.method_6200(TFPUtils.TRANSFORMER_GUN_MODIFIERS_UUID);
            instance.method_6200(TFPUtils.TRANSFORMER_WEAPON_MODIFIERS_UUID);
        }
        if (player.method_6032() > player.method_6063()) {
            player.method_6033(player.method_6063());
        }
        player.method_18382();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void readSavedData(class_2487 tag) {
        this.faction = Faction.byName(tag.method_10558("Faction"));
        class_2499 listTag = tag.method_10554("Variant", 2);
        if (listTag.size() == this.variant.size()) {
            for (int i = 0; i < listTag.size(); ++i) {
                this.setColor(i, HSBColor.fromShort(listTag.method_10609(i)));
            }
        }
        this.f5Vehicle = tag.method_10577("F5Swap");
        this.passengersLimit = tag.method_10571("PassengersLimit");
        this.darkEnergonExposure = tag.method_10550("DarkEnergon");
        this.readFlags(tag.method_10571("Flags"));
    }

    public void readFlags(byte flags) {
        this.transformed = (flags & 1) != 0;
        this.gun = (flags & 2) != 0;
        this.weapon = (flags & 4) != 0;
        this.specialActive = (flags & 8) != 0;
        this.vehicleSpecialActive = (flags & 0x10) != 0;
        this.minerMode = (flags & 0x20) != 0;
        this.vampire = (flags & 0x40) != 0;
    }

    public void save(class_2487 tag) {
        tag.method_10582("Type", this.getType().getName());
        tag.method_10582("Faction", this.faction.method_15434());
        class_2499 listTag = new class_2499();
        for (TransformerColorLayer layer : this.variant) {
            listTag.add((Object)class_2516.method_23254((short)layer.getColor().toShort()));
        }
        tag.method_10566("Variant", (class_2520)listTag);
        if (this.passengersLimit > 0) {
            tag.method_10567("PassengersLimit", this.passengersLimit);
        }
        tag.method_10567("DarkEnergon", (byte)this.darkEnergonExposure);
        tag.method_10556("F5Swap", this.f5Vehicle);
        tag.method_10567("Flags", this.saveFlags());
    }

    public byte saveFlags() {
        byte output = 0;
        if (this.transformed) {
            output = (byte)(output + 1);
        }
        if (this.gun) {
            output = (byte)(output + 2);
        }
        if (this.weapon) {
            output = (byte)(output + 4);
        }
        if (this.specialActive) {
            output = (byte)(output + 8);
        }
        if (this.vehicleSpecialActive) {
            output = (byte)(output + 16);
        }
        if (this.minerMode) {
            output = (byte)(output + 32);
        }
        if (this.vampire) {
            output = (byte)(output + 64);
        }
        return output;
    }

    public void setupAnimStates(class_1657 player) {
        if (this.playFallAnim == (player.field_6017 < 4.0f || this.isTransformed() || this.revertAnimState.method_41327())) {
            if (this.playFallAnim) {
                this.playFallAnim = false;
                this.fallAnimState.method_41325();
                this.landAnimState.method_41322(player.field_6012);
            } else {
                this.playFallAnim = true;
                this.fallAnimState.method_41322(player.field_6012);
                this.landAnimState.method_41325();
            }
        }
        if (!this.settled && player.field_6017 <= 0.0f && !this.revertAnimState.method_41327() && !this.landAnimState.method_41327()) {
            this.settleAnimState.method_41322(player.field_6012);
            this.settled = true;
        }
        if (this.crouching != player.method_18276()) {
            if (this.crouching) {
                this.crouching = false;
                this.crouchAnimState.method_41325();
                this.uncrouchAnimState.method_41324(player.field_6012);
            } else {
                this.crouching = true;
                this.uncrouchAnimState.method_41325();
                this.crouchAnimState.method_41324(player.field_6012);
            }
        }
        if (!this.attackAnimState.method_41327() && (player.field_6251 > 0.0f || this.attackAnimState.method_41327())) {
            this.attackAnimIndex = player.method_6051().method_43057();
            this.attackAnimState.method_41322(player.field_6012);
            if (this.isUsingWeapon(player)) {
                this.getSounds().getSound(TransformerSounds.Sound.SWING_WEAPON).ifPresent(sound -> player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15248, 1.0f, 0.8f + player.method_6051().method_43057() * 0.4f, false));
            }
        }
    }

    public void resetAnimStates(@Nullable class_1657 player) {
        this.idleAnimState.method_41322(0);
        this.getRevertAnimState().method_41325();
        if (this.isTransformed()) {
            this.transformAnimState.method_41322(Integer.MIN_VALUE);
        } else {
            this.transformAnimState.method_41325();
        }
        this.settled = false;
        this.settleAnimState.method_41322(Integer.MAX_VALUE);
        if (this.isGunLoaded()) {
            this.hideGunAnimState.method_41325();
            this.loadGunAnimState.method_41322(Integer.MIN_VALUE);
        } else {
            this.loadGunAnimState.method_41325();
            this.hideGunAnimState.method_41322(Integer.MIN_VALUE);
        }
        if (this.isUsingWeapon()) {
            this.hideWeaponAnimState.method_41325();
            this.loadWeaponAnimState.method_41322(Integer.MIN_VALUE);
        } else {
            this.loadWeaponAnimState.method_41325();
            this.hideWeaponAnimState.method_41322(Integer.MIN_VALUE);
        }
    }

    public boolean shouldDiscardViewBobbing() {
        return this.isTransformed();
    }

    @Override
    public class_7094 getTransformAnimState() {
        return this.transformAnimState;
    }

    @Override
    public class_7094 getRevertAnimState() {
        return this.revertAnimState;
    }

    @Override
    public class_7094 getSettleAnimState() {
        return this.settleAnimState;
    }

    @Override
    public class_7094 getAttackAnimState() {
        return this.attackAnimState;
    }

    @Override
    public class_7094 getIdleAnimState() {
        return this.idleAnimState;
    }

    @Override
    public class_7094 getCrouchAnimState() {
        return this.crouchAnimState;
    }

    @Override
    public class_7094 getUncrouchAnimState() {
        return this.uncrouchAnimState;
    }

    @Override
    public class_7094 getLoadGunAnimState() {
        return this.loadGunAnimState;
    }

    @Override
    public class_7094 getHideGunAnimState() {
        return this.hideGunAnimState;
    }

    @Override
    public class_7094 getLoadWeaponAnimState() {
        return this.loadWeaponAnimState;
    }

    @Override
    public class_7094 getHideWeaponAnimState() {
        return this.hideWeaponAnimState;
    }

    @Override
    public class_7094 getFallAnimState() {
        return this.fallAnimState;
    }

    @Override
    public class_7094 getLandAnimState() {
        return this.landAnimState;
    }

    @Override
    public float attackAnimIndex() {
        return this.attackAnimIndex;
    }

    public static PlayableTransformer fromNbt(class_2487 tag) {
        PlayableTransformer transformer = PlayableTransformers.get(tag.method_10558("Type")).get();
        transformer.readSavedData(tag);
        return transformer;
    }

    public static enum Faction implements class_3542
    {
        AUTOBOTS("autobots", ModItems.AUTOBOT_ARMOR, 0.34f, 0.8f, 1.0f, class_124.field_1079),
        DECEPTICONS("decepticons", ModItems.DECEPTICON_ARMOR, 0.9f, 0.17f, 0.17f, class_124.field_1064);

        private final String name;
        public final ModItems.TransformerArmor armor;
        public final float[] defaultGlowRGB;
        public final class_124 color;

        private Faction(String name, ModItems.TransformerArmor armor, float defaultGlowRed, float defaultGlowGreen, float defaultGlowBlue, class_124 color) {
            this.name = name;
            this.armor = armor;
            this.defaultGlowRGB = new float[]{defaultGlowRed, defaultGlowGreen, defaultGlowBlue};
            this.color = color;
        }

        public String method_15434() {
            return this.name;
        }

        public class_2561 getComponent() {
            return class_2561.method_43471((String)("faction.tfp." + this.method_15434())).method_27692(this.color);
        }

        public static Faction byName(String name) {
            for (Faction faction1 : Faction.values()) {
                if (!faction1.method_15434().equals(name)) continue;
                return faction1;
            }
            return AUTOBOTS;
        }
    }
}

