/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.PlayableTransformer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TransformerColorLayer
implements Cloneable {
    public static final float[] DARK_ENERGON_RGB = new float[]{0.75f, 0.25f, 1.0f};
    public static final float[] SYNTH_EN_RGB = new float[]{0.3f, 1.0f, 0.4f};
    public static final float[] VAMPIRE_RGB = new float[]{1.0f, 0.45f, 1.0f};
    public final String name;
    private HSBColor color;

    public TransformerColorLayer(String name) {
        this.name = name;
    }

    public static TransformerColorLayer cyanGlowing() {
        return new Glowing().setColor(13, 5);
    }

    public static TransformerColorLayer redGlowing() {
        return new Glowing().setColor(0, 6);
    }

    public HSBColor getColor() {
        return this.color;
    }

    public float[] getColor(class_1657 player, PlayableTransformer transformer) {
        return this.getColor().rgbFloats();
    }

    public TransformerColorLayer setColor(HSBColor color) {
        this.color = color;
        return this;
    }

    public TransformerColorLayer setColor(int hue, int saturation, int brightness) {
        return this.setColor(new HSBColor(hue, saturation, brightness));
    }

    public boolean shouldRender(class_1657 player, PlayableTransformer transformer, boolean altModel, float partialTick) {
        return !player.method_5767();
    }

    public boolean shouldRenderGlow(class_1657 player, PlayableTransformer transformer, boolean altModel, float partialTick) {
        return false;
    }

    public boolean brightColorsOnly() {
        return false;
    }

    public class_2960 getTextureLocation(class_1657 player, PlayableTransformer transformer, float partialTick) {
        return new class_2960("tfp", "textures/entity/transformer/%s/%s.png".formatted(transformer.getType().getName(), this.name));
    }

    public class_2561 getComponent() {
        return class_2561.method_43471((String)"colorlayer.%s.%s".formatted("tfp", this.name)).method_27692(class_124.field_1068);
    }

    public TransformerColorLayer clone() {
        try {
            return (TransformerColorLayer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static class Glowing
    extends TransformerColorLayer {
        private final AltGlowing altGlowing;

        public Glowing(String name, AltGlowing altGlowing) {
            super(name);
            this.altGlowing = altGlowing;
        }

        public Glowing(AltGlowing altGlowing) {
            this("glowing", altGlowing);
        }

        public Glowing(String name) {
            this(name, AltGlowing.NEVER);
        }

        public Glowing() {
            this(AltGlowing.NEVER);
        }

        @Override
        public boolean brightColorsOnly() {
            return true;
        }

        @Override
        public float[] getColor(class_1657 player, PlayableTransformer transformer) {
            return transformer.isVampire() ? VAMPIRE_RGB : (transformer.onDarkEnergon() ? DARK_ENERGON_RGB : (transformer.onSynthEn() ? SYNTH_EN_RGB : super.getColor(player, transformer)));
        }

        public Glowing setColor(int hue, int saturation) {
            return (Glowing)this.setColor(hue, saturation, 8);
        }

        @Override
        public boolean shouldRenderGlow(class_1657 player, PlayableTransformer transformer, boolean altModel, float partialTick) {
            return !altModel || this.altGlowing == AltGlowing.ALWAYS || this.altGlowing == AltGlowing.HEADLIGHTS && transformer.isVehicleSpecialActive();
        }
    }

    public static enum AltGlowing {
        NEVER,
        ALWAYS,
        HEADLIGHTS;

    }
}

