/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer;

import bnb.tfp.reg.ModRegisters;
import bnb.tfp.reg.ModSounds;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_3414;
import net.minecraft.class_3542;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class TransformerSounds {
    private final HashMap<Sound, Optional<? extends Supplier<class_3414>>> soundMap = new HashMap(Map.of(Sound.TRANSFORM, Optional.of(ModSounds.GENERIC_TRANSFORM), Sound.ENGINE, Optional.empty(), Sound.REVERT, Optional.of(ModSounds.GENERIC_REVERT), Sound.SHOOT, Optional.of(() -> ModSounds.BUMBLEBEE.getSound(Sound.SHOOT).orElseThrow()), Sound.EQUIP_GUN, Optional.of(ModSounds.GENERIC_EQUIP_GUN), Sound.HIDE_GUN, Optional.of(ModSounds.GENERIC_HIDE_GUN), Sound.EQUIP_WEAPON, Optional.empty(), Sound.HIDE_WEAPON, Optional.empty(), Sound.SWING_WEAPON, Optional.empty()));

    private TransformerSounds() {
    }

    public Optional<class_3414> getSound(Sound sound) {
        return this.soundMap.get((Object)sound).map(Supplier::get);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Sound implements class_3542
    {
        TRANSFORM("transform"),
        ENGINE("engine"),
        REVERT("revert"),
        SHOOT("shoot"),
        EQUIP_GUN("equip_gun"),
        HIDE_GUN("hide_gun"),
        EQUIP_WEAPON("equip_weapon"),
        HIDE_WEAPON("hide_weapon"),
        SWING_WEAPON("swing_weapon");

        private final String action;

        private Sound(String action) {
            this.action = action;
        }

        public String method_15434() {
            return this.action;
        }
    }

    public static class Builder {
        private final TransformerSounds sounds = new TransformerSounds();

        private Builder() {
        }

        public Builder put(Sound sound, @Nullable Supplier<class_3414> sup) {
            this.sounds.soundMap.put(sound, Optional.ofNullable(sup));
            return this;
        }

        public TransformerSounds build() {
            return this.sounds;
        }

        public TransformerSounds register(ModRegisters.OfName<Supplier<class_3414>> register, String name, Sound ... sounds) {
            for (Sound sound : sounds) {
                this.sounds.soundMap.put(sound, Optional.of(register.register("transformer.%s.%s".formatted(name, sound.method_15434()))));
            }
            return this.build();
        }

        public TransformerSounds registerNoWeapon(ModRegisters.OfName<Supplier<class_3414>> register, String name) {
            return this.register(register, name, Sound.TRANSFORM, Sound.ENGINE, Sound.REVERT, Sound.SHOOT, Sound.EQUIP_GUN, Sound.HIDE_GUN);
        }

        public TransformerSounds registerAll(ModRegisters.OfName<Supplier<class_3414>> register, String name) {
            return this.register(register, name, Sound.values());
        }
    }
}

