/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.transformer.vehicletypes;

import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.vehicletypes.Aircraft;
import bnb.tfp.transformer.vehicletypes.Car;
import bnb.tfp.transformer.vehicletypes.Helicopter;
import bnb.tfp.transformer.vehicletypes.Tank;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.Quaternionf;

public interface VehicleType {
    public static final VehicleType AIRCRAFT = new Aircraft(1.0, 2.5, 0.85);
    public static final VehicleType CAR = new Car(1.0, 2.0, 0.05, 0.04);
    public static final VehicleType HELICOPTER = new Helicopter(1.2, 0.75);
    public static final VehicleType TANK = new Tank(0.75, 1.5, 0.05, 0.035);

    public double maxSpeed();

    public void travel(PlayableTransformer var1, class_1657 var2, class_243 var3, class_2338 var4);

    default public boolean shouldTravelNormally(PlayableTransformer transformer, class_1657 player) {
        return !transformer.isTransformed();
    }

    default public void checkMovementStatistics(PlayableTransformer transformer, class_1657 player, double x, double y, double z) {
        player.method_7282(x, y, z);
    }

    default public float tickHeadTurn(class_1657 player, PlayableTransformer transformer, float yRot, float movement) {
        boolean b;
        float headRot = class_3532.method_15393((float)(yRot - player.field_6283));
        player.field_6283 += headRot * 0.3f;
        float headRot1 = class_3532.method_15393((float)(player.method_36454() - player.field_6283));
        if (Math.abs(headRot1) > 50.0f) {
            player.field_6283 += headRot1 - (float)(class_3532.method_17822((double)headRot1) * 50);
        }
        boolean bl = b = headRot1 < -90.0f || headRot1 >= 90.0f;
        if (b) {
            movement *= -1.0f;
        }
        return movement;
    }

    @Nullable
    default public Supplier<class_3414> defaultEngineSound() {
        return null;
    }

    default public Quaternionf getRenderRot(class_1657 player, PlayableTransformer transformer, float netHeadYaw, float headPitch, float partialTick, float transformation) {
        float swimAmount = player.method_6024(partialTick);
        if (swimAmount > 0.0f) {
            float maxXRot = player.method_5799() ? -90.0f - player.method_36455() : -90.0f;
            float xRot = class_3532.method_16439((float)swimAmount, (float)0.0f, (float)maxXRot);
            return class_7833.field_40714.rotationDegrees(xRot);
        }
        return new Quaternionf();
    }

    default public boolean shouldDoAFlip(class_1657 player, PlayableTransformer transformer) {
        return this.maxSpeed() - player.method_18798().method_1033() <= 0.025;
    }

    default public boolean shouldShowSpeedometer(class_1657 player, PlayableTransformer transformer) {
        return transformer.isTransformed();
    }

    default public double speedometerValue(class_1657 player, PlayableTransformer transformer, class_243 deltaMovement) {
        return deltaMovement.method_1033() / this.maxSpeed();
    }
}

