/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp;

import bnb.tfp.TFPData;
import bnb.tfp.client.ModKeys;
import bnb.tfp.client.gui.ModGui;
import bnb.tfp.client.model.transformer.bot.AbstractTransformerBotModel;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderer;
import bnb.tfp.client.renderer.entity.transformer.TransformerRenderers;
import bnb.tfp.reg.ClientRegister;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.commons.lang3.function.TriFunction;

@Mod.EventBusSubscriber(modid="tfp", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeClientClass {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClientRegister.registerMenuScreens(new ClientRegister.MenuScreenRegister(){

            @Override
            public <T extends AbstractContainerMenu, U extends Screen> void register(MenuType<T> type, TriFunction<T, Inventory, Component, U> constructor) {
                MenuScreens.m_96206_(type, (arg_0, arg_1, arg_2) -> constructor.apply(arg_0, arg_1, arg_2));
            }
        }));
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ClientRegister.registerRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1), (arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerBlockEntityRenderer(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ClientRegister.registerLayers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        ModKeys.init(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("speedometer", (gui, guiGraphics, partialTick, width, height) -> ModGui.renderSpeedometer((Player)Objects.requireNonNull(gui.getMinecraft().f_91074_), guiGraphics, partialTick, width, height));
    }

    @Mod.EventBusSubscriber(modid="tfp", value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void keyPressed(InputEvent.Key event) {
            ModKeys.keyPressed();
        }

        @SubscribeEvent
        public static void renderPlayer(RenderPlayerEvent.Pre event) {
            AbstractClientPlayer entity = (AbstractClientPlayer)event.getEntity();
            Entity vehicle = entity.m_20202_();
            if (vehicle != null && TFPData.clientInstance().isTransformer(vehicle)) {
                event.setCanceled(true);
                return;
            }
            PlayableTransformer transformer = TFPData.clientInstance().getTransformer((Player)entity);
            if (transformer == null) {
                return;
            }
            TransformerRenderer<?, ?, ?> transformerRenderer = TransformerRenderers.get(transformer.getType());
            transformerRenderer.copyModelProperties((PlayerModel<AbstractClientPlayer>)((PlayerModel)event.getRenderer().m_7200_()));
            transformerRenderer.render(entity, 0.0f, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void renderHand(RenderHandEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            PlayableTransformer transformer = TFPData.clientInstance().getTransformer((Player)player);
            if (transformer != null) {
                TransformerRenderer<?, ?, ?> renderer = TransformerRenderers.get(transformer.getType());
                if (event.getHand() == InteractionHand.OFF_HAND && player.m_21206_().m_41619_() || renderer.shouldCancelArmRendering((AbstractClientPlayer)player, transformer, player.m_5737_(), event.getPartialTick())) {
                    event.setCanceled(true);
                } else if (renderer.setStates(transformer) && ((AbstractTransformerBotModel)renderer.m_7200_()).shouldCancelArmSwinging()) {
                    event.setCanceled(true);
                    renderer.renderArmNoSwing((AbstractClientPlayer)player, transformer, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), player.m_5737_());
                }
            }
        }

        @SubscribeEvent
        public static void renderArm(RenderArmEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            PlayableTransformer transformer = TFPData.clientInstance().getTransformer((Player)player);
            if (transformer != null) {
                event.setCanceled(true);
                TransformerRenderers.get(transformer.getType()).setupModelAndRenderArm((AbstractClientPlayer)player, transformer, Minecraft.m_91087_().getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getArm());
            }
        }

        @SubscribeEvent
        public static void renderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91066_.f_92062_) {
                return;
            }
            Player player = (Player)Objects.requireNonNull(mc.f_91074_);
            ResourceLocation id = event.getOverlay().id();
            if (id.m_135827_().equals("minecraft")) {
                PlayableTransformer transformer = TFPData.clientInstance().getTransformer(player);
                if (transformer == null) {
                    return;
                }
                GuiGraphics guiGraphics = event.getGuiGraphics();
                ForgeGui gui = (ForgeGui)mc.f_91065_;
                switch (id.m_135815_()) {
                    case "food_level": {
                        boolean isMounted;
                        Entity vehicle = mc.f_91074_.m_20202_();
                        boolean bl = isMounted = vehicle != null && vehicle.m_20152_();
                        if (isMounted || !gui.shouldDrawSurvivalElements()) break;
                        event.setCanceled(true);
                        ModGui.renderEnergonBar(guiGraphics, mc.m_91307_(), player, transformer, player.m_217043_(), player.f_19797_, guiGraphics.m_280182_(), guiGraphics.m_280206_());
                        break;
                    }
                    case "crosshair": {
                        event.setCanceled(true);
                        gui.setupOverlayRenderState(true, false);
                        ModGui.renderCrosshair(mc, guiGraphics, player, transformer, guiGraphics.m_280182_(), guiGraphics.m_280206_());
                        break;
                    }
                    case "air_level": {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }
}

