/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp;

import bnb.tfp.CommonClass;
import bnb.tfp.Constants;
import bnb.tfp.TFPData;
import bnb.tfp.TFPUtils;
import bnb.tfp.command.TransformerCommands;
import bnb.tfp.data.ForgeBlockLoot;
import bnb.tfp.data.ForgeScrapletInfestedBlockStateProvider;
import bnb.tfp.data.ModRecipeProvider;
import bnb.tfp.data.ScrapletInfestedTagProvider;
import bnb.tfp.reg.ModEntities;
import bnb.tfp.reg.ModItems;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="tfp")
@Mod.EventBusSubscriber(modid="tfp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeCommonClass {
    public ForgeCommonClass() {
        Constants.LOG.info("Hello Forge world!");
        CommonClass.init();
        TFPUtils.setReach = (player, block, entity) -> {
            Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())).m_22100_(block.doubleValue());
            Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())).m_22100_(entity.doubleValue());
        };
    }

    @SubscribeEvent
    public static void registerTab(RegisterEvent event) {
        event.register(BuiltInRegistries.f_279662_.m_123023_(), helper -> helper.register("tfp", (Object)ModItems.buildTab(CreativeModeTab.builder())));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        ModEntities.registerAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerDataProviders(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ForgeBlockLoot::new, LootContextParamSets.f_81421_))));
        event.getGenerator().addProvider(event.includeServer(), ModRecipeProvider::new);
        event.getGenerator().addProvider(event.includeServer(), output -> new ScrapletInfestedTagProvider(output, event.getLookupProvider()));
        event.getGenerator().addProvider(event.includeClient(), output -> new ForgeScrapletInfestedBlockStateProvider(output, "tfp", event.getExistingFileHelper()));
    }

    @Mod.EventBusSubscriber(modid="tfp")
    public static class Events {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            TransformerCommands.init(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0));
        }

        @SubscribeEvent
        public static void setSize(EntityEvent.Size event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            PlayableTransformer transformer = TFPData.getInstance(player.m_9236_()).getTransformer(player);
            if (transformer == null) {
                return;
            }
            event.setNewEyeHeight(transformer.getEyeHeight(player, event.getPose(), event.getNewSize()));
        }

        @SubscribeEvent
        public static void transformersCantEatFood(LivingEntityUseItemEvent.Start event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            PlayableTransformer transformer = TFPData.getTransformerStatic(player);
            ItemStack stack = event.getItem();
            if (transformer != null && (transformer.isTransformed() || stack.m_41614_() && (transformer.isVampire() || !stack.m_204117_(ModItems.TRANSFORMERS_CAN_EAT)))) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void cantBreakBlockWithGun(PlayerInteractEvent.LeftClickBlock event) {
            Player player = event.getEntity();
            PlayableTransformer transformer = TFPData.getTransformerStatic(player);
            if (transformer != null && transformer.isUsingGun(player)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void applyTransformerDestroySpeedCoef(PlayerEvent.BreakSpeed event) {
            Player player = event.getEntity();
            PlayableTransformer transformer = TFPData.getTransformerStatic(player);
            if (transformer != null) {
                event.setNewSpeed(event.getOriginalSpeed() * transformer.getDestroySpeedCoef(player, event.getState()));
            }
        }

        @SubscribeEvent
        public static void transformerHarvestCheck(PlayerEvent.HarvestCheck event) {
            if (event.canHarvest()) {
                return;
            }
            Player player = event.getEntity();
            PlayableTransformer transformer = TFPData.getTransformerStatic(player);
            if (transformer == null) {
                return;
            }
            event.setCanHarvest(transformer.canHarvest(player, event.getTargetBlock()));
        }

        @SubscribeEvent
        public static void transformerMineBlock(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (player == null || player.m_6047_()) {
                return;
            }
            PlayableTransformer transformer = TFPData.getTransformerStatic(player);
            if (transformer == null || !transformer.isMinerMode() || transformer.isUsingGun(player) || transformer.isUsingWeapon(player)) {
                return;
            }
            Level lvl = player.m_9236_();
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            for (int x = pos.m_123341_() - 1; x <= pos.m_123341_() + 1; ++x) {
                for (int y = pos.m_123342_() - 1; y <= pos.m_123342_() + 1; ++y) {
                    for (int z = pos.m_123343_() - 1; z <= pos.m_123343_() + 1; ++z) {
                        BlockPos pos1 = new BlockPos(x, y, z);
                        if (pos.equals((Object)pos1) || !lvl.m_8055_(pos1).equals(state)) continue;
                        boolean willHarvest = state.canHarvestBlock((BlockGetter)lvl, pos1, player);
                        state.onDestroyedByPlayer(lvl, pos1, player, willHarvest, lvl.m_6425_(pos1));
                        if (!willHarvest || player.m_150110_().f_35937_) continue;
                        Block.dropResources((BlockState)state, (Level)lvl, (BlockPos)pos1, (BlockEntity)lvl.m_7702_(pos1), (Entity)player, (ItemStack)player.m_21205_(), (!player.m_150110_().f_35937_ ? 1 : 0) != 0);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void transformerRespawn(PlayerEvent.PlayerRespawnEvent event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            PlayableTransformer transformer = TFPData.serverInstance(player.f_8924_).getTransformer((Player)player);
            if (transformer != null) {
                transformer.setupTransformer(player);
            }
        }

        @SubscribeEvent
        public static void join(PlayerEvent.PlayerLoggedInEvent event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            ModNetworking.send(player, new TFPData.ClientboundPacket(TFPData.serverInstance(player.f_8924_)));
            player.m_6210_();
        }
    }
}

