/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp;

import bnb.tfp.TFPData;
import bnb.tfp.network.ClientboundDarkEnergonExposurePacket;
import bnb.tfp.network.ClientboundLongAttackPacket;
import bnb.tfp.network.ClientboundSetTransformerPacket;
import bnb.tfp.network.ClientboundTransformerActionPacket;
import bnb.tfp.network.ClientboundVampireTerrorconPacket;
import bnb.tfp.network.CreateGroundBridgePacket;
import bnb.tfp.network.LongAttackPacket;
import bnb.tfp.network.ModClientboundPacket;
import bnb.tfp.network.ModServerboundPacket;
import bnb.tfp.network.SetTransformerPacket;
import bnb.tfp.network.TransformerActionPacket;
import bnb.tfp.reg.ModNetworking;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="tfp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeNetworking {
    private static final Supplier<String> PROTOCOL_VERSION = () -> "1";
    private static final Predicate<String> ACCEPT_VERSION = s -> true;
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tfp", "main"), PROTOCOL_VERSION, ACCEPT_VERSION, ACCEPT_VERSION);

    @SubscribeEvent
    public static void registerMessages(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            int id = 0;
            ForgeNetworking.regClientbound(id++, TFPData.ClientboundPacket.class, TFPData.ClientboundPacket::new);
            ForgeNetworking.regClientbound(id++, ClientboundTransformerActionPacket.class, ClientboundTransformerActionPacket::new);
            ForgeNetworking.regClientbound(id++, ClientboundSetTransformerPacket.class, ClientboundSetTransformerPacket::new);
            ForgeNetworking.regClientbound(id++, ClientboundLongAttackPacket.class, ClientboundLongAttackPacket::new);
            ForgeNetworking.regClientbound(id++, ClientboundDarkEnergonExposurePacket.class, ClientboundDarkEnergonExposurePacket::new);
            ForgeNetworking.regClientbound(id++, ClientboundVampireTerrorconPacket.class, ClientboundVampireTerrorconPacket::new);
            ForgeNetworking.regServerbound(id++, SetTransformerPacket.class, SetTransformerPacket::new);
            ForgeNetworking.regServerbound(id++, TransformerActionPacket.class, TransformerActionPacket::new);
            ForgeNetworking.regServerbound(id++, LongAttackPacket.class, LongAttackPacket::new);
            ForgeNetworking.regServerbound(id, CreateGroundBridgePacket.class, CreateGroundBridgePacket::new);
            ModNetworking.init((player, packet) -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet), (server, packet) -> CHANNEL.send(PacketDistributor.ALL.noArg(), packet), arg_0 -> ((SimpleChannel)CHANNEL).sendToServer(arg_0));
        });
    }

    private static <T extends ModClientboundPacket> void regClientbound(int id, Class<T> msgClass, Function<FriendlyByteBuf, T> decoder) {
        CHANNEL.registerMessage(id, msgClass, ModClientboundPacket::write, decoder, (msg, supplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)supplier.get();
            ctx.enqueueWork(msg::handle);
            ctx.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private static <T extends ModServerboundPacket> void regServerbound(int id, Class<T> msgClass, Function<FriendlyByteBuf, T> decoder) {
        CHANNEL.registerMessage(id, msgClass, ModServerboundPacket::write, decoder, (msg, supplier) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)supplier.get();
            ctx.enqueueWork(() -> msg.handle(ctx.getSender()));
            ctx.setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }
}

