/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp;

import bnb.tfp.network.ModClientboundPacket;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class TFPData
extends SavedData {
    private final HashMap<UUID, PlayableTransformer> transformers;
    private static final TFPData CLIENT_INSTANCE = new TFPData(){

        public void m_77760_(boolean p_77761_) {
        }
    };

    private TFPData() {
        this(new HashMap<UUID, PlayableTransformer>());
    }

    private TFPData(HashMap<UUID, PlayableTransformer> transformers) {
        this.transformers = transformers;
    }

    public TFPData load(CompoundTag tag) {
        this.transformers.clear();
        tag.m_128431_().forEach(string -> this.transformers.put(UUID.fromString(string), PlayableTransformer.fromNbt(tag.m_128469_(string))));
        return this;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        this.transformers.forEach((uuid, transformer) -> {
            CompoundTag tag1 = new CompoundTag();
            tag1.m_128359_("Type", transformer.getType().getName());
            transformer.save(tag1);
            tag.m_128365_(uuid.toString(), (Tag)tag1);
        });
        return tag;
    }

    public PlayableTransformer getTransformer(UUID uuid) {
        return this.transformers.get(uuid);
    }

    public PlayableTransformer getTransformer(Player player) {
        try {
            return player.m_5833_() ? null : this.getTransformer(player.m_20148_());
        }
        catch (NullPointerException ingnored) {
            return this.getTransformer(player.m_20148_());
        }
    }

    public boolean isTransformer(UUID uuid) {
        return this.transformers.containsKey(uuid);
    }

    public boolean isTransformer(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        try {
            return !player.m_5833_() && this.isTransformer(player.m_20148_());
        }
        catch (NullPointerException ignored) {
            return this.isTransformer(player.m_20148_());
        }
    }

    public Set<UUID> getTransformerPlayersUUIDs() {
        return Set.copyOf(this.transformers.keySet());
    }

    public boolean setTransformer(UUID uuid, PlayableTransformer transformer) {
        if (!transformer.getType().canUseVariant(this, transformer.getColors(), uuid)) {
            return false;
        }
        this.transformers.put(uuid, transformer);
        this.m_77762_();
        return true;
    }

    public boolean setTransformer(Player player, PlayableTransformer transformer) {
        return this.setTransformer(player.m_20148_(), transformer);
    }

    public void clearTransformer(UUID uuid) {
        this.transformers.remove(uuid);
        this.m_77762_();
    }

    public void clearTransformer(Player player) {
        this.clearTransformer(player.m_20148_());
    }

    public boolean contains(BiPredicate<UUID, PlayableTransformer> predicate) {
        return this.transformers.entrySet().stream().anyMatch(entry -> predicate.test((UUID)entry.getKey(), (PlayableTransformer)entry.getValue()));
    }

    public static TFPData clientInstance() {
        return CLIENT_INSTANCE;
    }

    public static TFPData serverInstance(MinecraftServer server) {
        return (TFPData)server.m_129783_().m_8895_().m_164861_(tag -> new TFPData().load((CompoundTag)tag), TFPData::new, "tfp_data");
    }

    public static TFPData getInstance(Level lvl) {
        return lvl.f_46443_ ? CLIENT_INSTANCE : TFPData.serverInstance(Objects.requireNonNull(lvl.m_7654_()));
    }

    public static PlayableTransformer getTransformerStatic(Player player) {
        return TFPData.getInstance(player.m_9236_()).getTransformer(player);
    }

    public static boolean isTransformerStatic(Entity entity) {
        return TFPData.getInstance(entity.m_9236_()).isTransformer(entity);
    }

    public static class ClientboundPacket
    implements ModClientboundPacket {
        private final CompoundTag data;

        protected ClientboundPacket(CompoundTag data) {
            this.data = data;
        }

        public ClientboundPacket(TFPData tfpData) {
            this(tfpData.m_7176_(new CompoundTag()));
        }

        public ClientboundPacket(FriendlyByteBuf buf) {
            this(Objects.requireNonNull(buf.m_130260_()));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_130079_(this.data);
        }

        @Override
        public void handle(Minecraft mc) {
            CLIENT_INSTANCE.load(this.data);
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_6210_();
            }
        }
    }
}

