/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import bnb.tfp.block.EnergonPowered;
import bnb.tfp.reg.ModBlocks;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonCableBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty CORNER = BooleanProperty.m_61465_((String)"corner");
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    protected EnergonCableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(false)));
    }

    public EnergonCableBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60955_().m_60910_().m_60978_(0.1f).m_60966_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbor, LevelAccessor lvl, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)lvl, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        AtomicReference<BlockState> reference = new AtomicReference<BlockState>(state);
        EnergonCableBlock.getOccupiedEndIfHasFreeOne(lvl, pos, state).ifPresent(direction1 -> {
            if (neighbor.m_60713_((Block)ModBlocks.ENERGON_TANK.get()) || neighbor.m_60734_() instanceof EnergonPowered || neighbor.m_60713_((Block)this) && neighbor.m_60713_((Block)this) && EnergonCableBlock.getOccupiedEndIfHasFreeOne(lvl, neighborPos, neighbor).isPresent()) {
                reference.set(EnergonCableBlock.setEnds(state, direction, direction1));
            }
        });
        return reference.get();
    }

    public boolean m_7898_(BlockState state, LevelReader lvl, BlockPos pos) {
        return lvl.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)lvl, pos, Direction.UP);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_();
        Level lvl = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction);
        for (Direction direction1 : new Direction[]{direction.m_122427_(), direction.m_122428_()}) {
            BlockPos pos1 = pos.m_121945_(direction1);
            state = state.m_60728_(direction1, lvl.m_8055_(pos1), (LevelAccessor)lvl, pos, pos1);
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, CORNER});
    }

    public static Direction getFirstEnd(BlockState state) {
        return (Direction)state.m_61143_((Property)f_54117_);
    }

    public static Direction getSecondEnd(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return (Boolean)state.m_61143_((Property)CORNER) != false ? direction.m_122427_() : direction.m_122424_();
    }

    public static BlockState setEnds(BlockState state, Direction end1, Direction end2) {
        state = end1.m_122434_() == end2.m_122434_() ? (BlockState)((BlockState)state.m_61124_((Property)f_54117_, (Comparable)end1)).m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)state.m_61124_((Property)CORNER, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)(end2 == end1.m_122427_() ? end1 : end2));
        return state;
    }

    public static Optional<Direction> getOccupiedEndIfHasFreeOne(LevelAccessor lvl, BlockPos pos, BlockState state) {
        for (int i = 0; i < 2; ++i) {
            boolean b = i > 0;
            Direction direction = b ? EnergonCableBlock.getFirstEnd(state) : EnergonCableBlock.getSecondEnd(state);
            BlockState state1 = lvl.m_8055_(pos.m_121945_(direction));
            if (state1.m_60713_((Block)ModBlocks.ENERGON_TANK.get()) || state1.m_60734_() instanceof EnergonPowered || state1.m_60713_((Block)ModBlocks.ENERGON_CABLE.get()) && (EnergonCableBlock.getFirstEnd(state1) == direction.m_122424_() || EnergonCableBlock.getSecondEnd(state1) == direction.m_122424_())) continue;
            return Optional.of(b ? EnergonCableBlock.getSecondEnd(state) : EnergonCableBlock.getFirstEnd(state));
        }
        return Optional.empty();
    }

    public static void doToConnectedBlock(LevelAccessor lvl, BlockPos pos, Direction direction, BiConsumer<BlockPos, BlockState> action) {
        BlockPos pos1 = pos.m_121945_(direction);
        BlockState state = lvl.m_8055_(pos1);
        if (state.m_60713_((Block)ModBlocks.ENERGON_CABLE.get())) {
            Direction direction1;
            if (EnergonCableBlock.getFirstEnd(state) == direction.m_122424_()) {
                direction1 = EnergonCableBlock.getSecondEnd(state);
            } else if (EnergonCableBlock.getSecondEnd(state) == direction.m_122424_()) {
                direction1 = EnergonCableBlock.getFirstEnd(state);
            } else {
                return;
            }
            if (direction1 != direction.m_122424_()) {
                EnergonCableBlock.doToConnectedBlock(lvl, pos1, direction1, action);
            }
        } else {
            action.accept(pos1, state);
        }
    }
}

