/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import bnb.tfp.block.EnergonPowered;
import bnb.tfp.blockentity.EnergonConverterBlockEntity;
import bnb.tfp.reg.ModBlockEntities;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonConverterBlock
extends BaseEntityBlock
implements EnergonPowered {
    private static final VoxelShape SHAPE_AABB = Shapes.m_83124_((VoxelShape)EnergonConverterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), (VoxelShape[])new VoxelShape[]{EnergonConverterBlock.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)21.0, (double)14.0), EnergonConverterBlock.m_49796_((double)4.0, (double)21.0, (double)4.0, (double)12.0, (double)31.0, (double)12.0)});
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public EnergonConverterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public EnergonConverterBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 1200.0f).m_60955_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menu = this.m_7246_(state, level, pos);
        if (menu != null) {
            player.m_5893_(menu);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!newState.m_60713_(state.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof EnergonConverterBlockEntity) {
            EnergonConverterBlockEntity blockEntity2 = (EnergonConverterBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)blockEntity2);
            if (blockEntity2.getXpPoints() > 0) {
                level.m_7967_((Entity)new ExperienceOrb(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, blockEntity2.getXpPoints()));
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    @Override
    public float poweredTick(Level lvl, BlockPos pos, BlockState state) {
        EnergonConverterBlockEntity blockEntity;
        BlockEntity blockEntity2;
        return !lvl.m_276867_(pos) && (blockEntity2 = lvl.m_7702_(pos)) instanceof EnergonConverterBlockEntity && EnergonConverterBlockEntity.tick(5, lvl, blockEntity = (EnergonConverterBlockEntity)blockEntity2, 1.5f) ? 1.851E-4f : 0.0f;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EnergonConverterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return EnergonConverterBlock.m_152132_(blockEntityType, ModBlockEntities.ENERGON_CONVERTER.get(), EnergonConverterBlockEntity::tick);
    }
}

