/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonCrystalBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.f_61376_;
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final VoxelShape FLOOR_X = Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)14.0, (double)13.0);
    public static final VoxelShape FLOOR_Z = Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)14.0, (double)12.0);
    public static final VoxelShape CEIL_X = Block.m_49796_((double)4.0, (double)2.0, (double)3.0, (double)12.0, (double)16.0, (double)13.0);
    public static final VoxelShape CEIL_Z = Block.m_49796_((double)3.0, (double)2.0, (double)4.0, (double)13.0, (double)16.0, (double)12.0);
    public static final VoxelShape WALL_N = Block.m_49796_((double)4.0, (double)3.0, (double)2.0, (double)12.0, (double)13.0, (double)16.0);
    public static final VoxelShape WALL_S = Block.m_49796_((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)14.0);
    public static final VoxelShape WALL_E = Block.m_49796_((double)0.0, (double)3.0, (double)4.0, (double)14.0, (double)13.0, (double)12.0);
    public static final VoxelShape WALL_W = Block.m_49796_((double)2.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0, (double)12.0);

    protected EnergonCrystalBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(ATTACH_FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public EnergonCrystalBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154654_).m_60999_().m_60913_(8.0f, 6.0f).m_278166_(PushReaction.BLOCK).m_60991_((state, block, pos) -> true).m_60953_(state -> 9));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext ctx) {
        VoxelShape shape = FLOOR_Z;
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_(ATTACH_FACE)) {
            case WALL: {
                switch (facing) {
                    case NORTH: {
                        shape = WALL_N;
                        break;
                    }
                    case EAST: {
                        shape = WALL_E;
                        break;
                    }
                    case SOUTH: {
                        shape = WALL_S;
                        break;
                    }
                    case WEST: {
                        shape = WALL_W;
                    }
                }
                break;
            }
            case FLOOR: {
                shape = facing.m_122434_() == Direction.Axis.X ? FLOOR_X : FLOOR_Z;
                break;
            }
            case CEILING: {
                shape = facing.m_122434_() == Direction.Axis.X ? CEIL_X : CEIL_Z;
            }
        }
        return shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_));
        Direction face = ctx.m_43719_();
        switch (face) {
            case DOWN: {
                state = (BlockState)((BlockState)state.m_61124_(ATTACH_FACE, (Comparable)AttachFace.CEILING)).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122427_());
                break;
            }
            case UP: {
                state = (BlockState)((BlockState)state.m_61124_(ATTACH_FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122427_());
                break;
            }
            default: {
                state = (BlockState)((BlockState)state.m_61124_(ATTACH_FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)face);
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, ATTACH_FACE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static boolean tryPlaceOnBLock(BlockState energonState, WorldGenLevel lvl, BlockPos pos, Direction direction, RandomSource random) {
        BlockPos energonPos = pos.m_121945_(direction);
        BlockState toReplace = lvl.m_8055_(energonPos);
        if (!toReplace.m_60795_() && !toReplace.m_60713_(Blocks.f_49990_)) {
            return false;
        }
        BlockState state = (BlockState)energonState.m_263224_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(toReplace.m_60819_().m_76152_().equals(Fluids.f_76193_)));
        state = direction == Direction.UP || direction == Direction.DOWN ? (BlockState)((BlockState)state.m_263224_(ATTACH_FACE, (Comparable)(direction == Direction.UP ? AttachFace.FLOOR : AttachFace.CEILING))).m_61124_((Property)f_54117_, (Comparable)HORIZONTAL_DIRECTIONS[random.m_188503_(HORIZONTAL_DIRECTIONS.length)]) : (BlockState)((BlockState)state.m_263224_(ATTACH_FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction);
        lvl.m_7731_(energonPos, state, 3);
        return true;
    }
}

