/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import bnb.tfp.TFPUtils;
import bnb.tfp.block.EnergonPowered;
import bnb.tfp.blockentity.GroundBridgeControlBlockEntity;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GroundBridgeControlBlock
extends BaseEntityBlock
implements EnergonPowered {
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)10.0, (double)5.0), Block.m_49796_((double)4.0, (double)8.0, (double)2.0, (double)12.0, (double)10.0, (double)12.0), Block.m_49796_((double)4.0, (double)10.0, (double)2.0, (double)12.0, (double)15.0, (double)6.0), Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)24.0, (double)4.0)});
    private static final VoxelShape SHAPE_EAST = TFPUtils.clockwise(SHAPE_NORTH);
    private static final VoxelShape SHAPE_SOUTH = TFPUtils.clockwise(SHAPE_EAST);
    private static final VoxelShape SHAPE_WEST = TFPUtils.clockwise(SHAPE_SOUTH);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected GroundBridgeControlBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public GroundBridgeControlBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60918_(SoundType.f_56743_).m_60913_(5.0f, 1200.0f).m_60955_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED, POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext ctx) {
        VoxelShape output = SHAPE_NORTH;
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case EAST: {
                output = SHAPE_EAST;
                break;
            }
            case SOUTH: {
                output = SHAPE_SOUTH;
                break;
            }
            case WEST: {
                output = SHAPE_WEST;
            }
        }
        return output;
    }

    public InteractionResult m_6227_(BlockState state, Level lvl, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = lvl.m_7702_(pos);
        if (!(blockEntity instanceof GroundBridgeControlBlockEntity)) {
            return InteractionResult.FAIL;
        }
        GroundBridgeControlBlockEntity blockEntity2 = (GroundBridgeControlBlockEntity)blockEntity;
        blockEntity2.use(state, lvl, pos, player);
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level lvl, BlockPos pos, BlockState replaceWith, boolean p_60519_) {
        BlockEntity blockEntity = lvl.m_7702_(pos);
        if (blockEntity instanceof GroundBridgeControlBlockEntity) {
            GroundBridgeControlBlockEntity blockEntity2 = (GroundBridgeControlBlockEntity)blockEntity;
            blockEntity2.removePortals(lvl);
        }
        super.m_6810_(state, lvl, pos, replaceWith, p_60519_);
    }

    @Override
    public void onPowered(Level lvl, BlockPos pos, BlockState state) {
        lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
    }

    @Override
    public float poweredTick(Level lvl, BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)ENABLED) != false ? 4.16E-5f : 0.0f;
    }

    @Override
    public void onUnpowered(Level lvl, BlockPos pos, BlockState state) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)ENABLED)).booleanValue() && (blockEntity = lvl.m_7702_(pos)) instanceof GroundBridgeControlBlockEntity) {
            GroundBridgeControlBlockEntity blockEntity2 = (GroundBridgeControlBlockEntity)blockEntity;
            blockEntity2.removePortals(lvl);
            blockEntity2.animTick = 0;
        }
        lvl.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)), 2);
    }

    public static void setEnabled(Level lvl, BlockPos pos, BlockState state, boolean value) {
        BlockEntity blockEntity = lvl.m_7702_(pos);
        if (blockEntity instanceof GroundBridgeControlBlockEntity) {
            GroundBridgeControlBlockEntity blockEntity2 = (GroundBridgeControlBlockEntity)blockEntity;
            blockEntity2.animTick = 0;
        }
        lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(value)), 1);
        lvl.m_247517_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GroundBridgeControlBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level lvl, BlockState state, BlockEntityType<T> type) {
        return (lvl1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof GroundBridgeControlBlockEntity) {
                GroundBridgeControlBlockEntity control = (GroundBridgeControlBlockEntity)blockEntity;
                control.animTick = (short)(control.animTick + 1);
            }
        };
    }
}

