/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import bnb.tfp.TFPUtils;
import bnb.tfp.block.EnergonPowered;
import bnb.tfp.blockentity.LaptopBlockEntity;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LaptopBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
EnergonPowered {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final VoxelShape BASE_AABB = LaptopBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.5, (double)13.0);
    private static final VoxelShape SCREEN_AABB = LaptopBlock.m_49796_((double)1.0, (double)1.0, (double)12.0, (double)15.0, (double)11.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)BASE_AABB, (VoxelShape)SCREEN_AABB);
    private static final VoxelShape SHAPE_EAST = TFPUtils.clockwise(SHAPE_NORTH);
    private static final VoxelShape SHAPE_SOUTH = TFPUtils.clockwise(SHAPE_EAST);
    private static final VoxelShape SHAPE_WEST = TFPUtils.clockwise(SHAPE_SOUTH);
    private static final VoxelShape SHAPE_CLOSED_NORTH = LaptopBlock.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0, (double)14.0);
    private static final VoxelShape SHAPE_CLOSED_EAST = TFPUtils.clockwise(SHAPE_CLOSED_NORTH);
    private static final VoxelShape SHAPE_CLOSED_SOUTH = TFPUtils.clockwise(SHAPE_CLOSED_EAST);
    private static final VoxelShape SHAPE_CLOSED_WEST = TFPUtils.clockwise(SHAPE_CLOSED_SOUTH);

    protected LaptopBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
    }

    public LaptopBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56743_).m_60978_(1.0f).m_60953_(state -> (Boolean)state.m_61143_((Property)OPEN) != false && (Boolean)state.m_61143_((Property)POWERED) != false ? 6 : 0));
    }

    public InteractionResult m_6227_(BlockState state, Level lvl, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean open = (Boolean)state.m_61143_((Property)OPEN) == false;
        lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
        lvl.m_5594_(null, pos, open ? SoundEvents.f_12629_ : SoundEvents.f_12628_, SoundSource.BLOCKS, 1.0f, 0.9f + lvl.f_46441_.m_188501_() * 0.1f);
        return InteractionResult.m_19078_((boolean)lvl.f_46443_);
    }

    @Override
    public void onPowered(Level lvl, BlockPos pos, BlockState state) {
        lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
    }

    @Override
    public float poweredTick(Level lvl, BlockPos pos, BlockState state) {
        Direction.Axis[] axisArray;
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue() || !((axisArray = lvl.m_7702_(pos)) instanceof LaptopBlockEntity)) {
            return 0.0f;
        }
        LaptopBlockEntity laptop = (LaptopBlockEntity)axisArray;
        if (lvl.f_46443_) {
            for (Direction.Axis axis : Direction.Axis.f_122448_) {
                laptop.axisTicks.put(axis, laptop.axisTicks.get(axis) + 1);
            }
        } else if (lvl.m_46467_() % 20L == 0L) {
            laptop.updateTracking(lvl, pos);
        }
        return 1.4E-5f;
    }

    @Override
    public void onUnpowered(Level lvl, BlockPos pos, BlockState state) {
        lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext ctx) {
        VoxelShape output = SHAPE_NORTH;
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case NORTH: {
                output = open ? SHAPE_NORTH : SHAPE_CLOSED_NORTH;
                break;
            }
            case EAST: {
                output = open ? SHAPE_EAST : SHAPE_CLOSED_EAST;
                break;
            }
            case SOUTH: {
                output = open ? SHAPE_SOUTH : SHAPE_CLOSED_SOUTH;
                break;
            }
            case WEST: {
                output = open ? SHAPE_WEST : SHAPE_CLOSED_WEST;
            }
        }
        return output;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbor, LevelAccessor lvl, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)lvl, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighbor, lvl, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader lvl, BlockPos pos) {
        return lvl.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)lvl, pos, Direction.UP);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POWERED, OPEN});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LaptopBlockEntity(pos, state);
    }
}

