/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import bnb.tfp.blockentity.ScrapletInfestedBlockEntity;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScrapletInfestedBlock
extends Block
implements EntityBlock {
    private static final HashMap<Block, ScrapletInfestedBlock> BLOCK_BY_HOST_BLOCK = new HashMap();
    public final Block hostBlock;

    public ScrapletInfestedBlock(Block hostBlock) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)hostBlock).m_222994_().m_155954_(hostBlock.m_155943_() * 0.5f));
        this.hostBlock = hostBlock;
        BLOCK_BY_HOST_BLOCK.put(hostBlock, this);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent name;
        CompoundTag blockEntityData = BlockItem.m_186336_((ItemStack)stack);
        if (blockEntityData != null && (name = Component.Serializer.m_130701_((String)blockEntityData.m_128469_("ScrapletData").m_128461_("CustomName"))) != null) {
            tooltip.add((Component)name.m_130948_(name.m_7383_().m_178520_(9800411)));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        BlockEntity blockEntity;
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && player.m_217043_().m_188501_() < 0.25f && (blockEntity = level.m_7702_(pos)) instanceof ScrapletInfestedBlockEntity) {
            ScrapletInfestedBlockEntity blockEntity2 = (ScrapletInfestedBlockEntity)blockEntity;
            level.m_46961_(pos, false);
            blockEntity2.releaseScraplet(level, pos);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ScrapletInfestedBlockEntity) {
            ScrapletInfestedBlockEntity blockEntity2 = (ScrapletInfestedBlockEntity)blockEntity;
            if (((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46136_)).m_46223_() && (player.m_7500_() || EnchantmentHelper.m_272262_((ItemStack)player.m_21205_()))) {
                ItemStack stack = this.m_5456_().m_7968_();
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)blockEntity2.m_58903_(), (CompoundTag)blockEntity2.m_187482_());
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        if (!level.f_46443_ && blockEntity instanceof ScrapletInfestedBlockEntity) {
            ScrapletInfestedBlockEntity scrapletInfestedBlockEntity = (ScrapletInfestedBlockEntity)blockEntity;
            if (((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46136_)).m_46223_() && !EnchantmentHelper.m_272262_((ItemStack)tool)) {
                scrapletInfestedBlockEntity.releaseScraplet(level, pos);
            }
        }
    }

    public static boolean canBeInfested(Block block) {
        return BLOCK_BY_HOST_BLOCK.containsKey(block);
    }

    @Nullable
    public static BlockState infest(BlockState state) {
        ScrapletInfestedBlock scrapletInfestedBlock = BLOCK_BY_HOST_BLOCK.get(state.m_60734_());
        return scrapletInfestedBlock != null ? scrapletInfestedBlock.m_49966_() : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ScrapletInfestedBlockEntity(blockPos, blockState);
    }
}

