/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.block;

import bnb.tfp.TFPUtils;
import bnb.tfp.blockentity.LaptopBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SignalNavigatorBlock
extends HorizontalDirectionalBlock {
    private static final VoxelShape BATTERY_AABB = SignalNavigatorBlock.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)7.0, (double)2.0, (double)12.0);
    private static final VoxelShape ANTENNA_BASE_AABB = SignalNavigatorBlock.m_49796_((double)9.0, (double)0.0, (double)7.0, (double)14.0, (double)2.0, (double)12.0);
    private static final VoxelShape ANTENNA_POLE_AABB = SignalNavigatorBlock.m_49796_((double)11.0, (double)2.0, (double)9.0, (double)12.0, (double)8.0, (double)10.0);
    private static final VoxelShape ANTENNA_ATTACHMENT_AABB = SignalNavigatorBlock.m_49796_((double)10.5, (double)8.0, (double)8.5, (double)12.5, (double)10.0, (double)10.5);
    private static final VoxelShape ANTENNA_PLATE_AABB = SignalNavigatorBlock.m_49796_((double)7.5, (double)5.0, (double)5.5, (double)15.5, (double)13.0, (double)8.5);
    private static final VoxelShape ANTENNA_AABB = SignalNavigatorBlock.m_49796_((double)11.0, (double)8.5, (double)3.5, (double)12.0, (double)9.5, (double)8.5);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)BATTERY_AABB, (VoxelShape[])new VoxelShape[]{ANTENNA_BASE_AABB, ANTENNA_POLE_AABB, ANTENNA_ATTACHMENT_AABB, ANTENNA_PLATE_AABB, ANTENNA_AABB});
    private static final VoxelShape SHAPE_EAST = TFPUtils.clockwise(SHAPE_NORTH);
    private static final VoxelShape SHAPE_SOUTH = TFPUtils.clockwise(SHAPE_EAST);
    private static final VoxelShape SHAPE_WEST = TFPUtils.clockwise(SHAPE_SOUTH);

    protected SignalNavigatorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public SignalNavigatorBlock() {
        this(BlockBehaviour.Properties.m_284310_().m_60955_().m_60918_(SoundType.f_56743_).m_60978_(0.5f));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter lvl, BlockPos pos, CollisionContext ctx) {
        VoxelShape output = SHAPE_NORTH;
        switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case EAST: {
                output = SHAPE_EAST;
                break;
            }
            case SOUTH: {
                output = SHAPE_SOUTH;
                break;
            }
            case WEST: {
                output = SHAPE_WEST;
            }
        }
        return output;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbor, LevelAccessor lvl, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)lvl, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighbor, lvl, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader lvl, BlockPos pos) {
        return lvl.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)lvl, pos, Direction.UP);
    }

    public InteractionResult m_6227_(BlockState state, Level lvl, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            BlockPos laptopPos = pos.m_121945_(direction);
            BlockEntity blockEntity = lvl.m_7702_(laptopPos);
            if (!(blockEntity instanceof LaptopBlockEntity)) continue;
            LaptopBlockEntity laptop = (LaptopBlockEntity)blockEntity;
            if (lvl.f_46443_) {
                return InteractionResult.CONSUME;
            }
            List<Player> players = lvl.m_6907_().stream().filter(player1 -> LaptopBlockEntity.canTrackPlayer(player, pos)).toList();
            if (players.isEmpty()) {
                laptop.setTracked(null);
                laptop.updateTracking(lvl, laptopPos);
            } else {
                Player player12 = laptop.getTracked().map(arg_0 -> ((Level)lvl).m_46003_(arg_0)).map(tracked -> {
                    int index = players.indexOf(tracked);
                    return (Player)players.get(index < 0 || index >= players.size() - 1 ? 0 : index + 1);
                }).orElse(players.get(0));
                if (laptop.getTracked().map(player12.m_20148_()::equals).orElse(false).booleanValue()) {
                    return InteractionResult.CONSUME;
                }
                laptop.setTracked(player12.m_20148_());
                laptop.updateTracking(lvl, laptopPos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }
}

