/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.blockentity;

import bnb.tfp.inventory.EnergonConverterMenu;
import bnb.tfp.reg.ModBlockEntities;
import bnb.tfp.reg.ModItems;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonConverterBlockEntity
extends BaseContainerBlockEntity {
    public static final List<Map<Item, Integer>> INGREDIENT_VALUES = List.of(Map.of(Items.f_41999_, 1, Items.f_42754_, 5), Map.of(Items.f_42447_, 1, Items.f_42586_, 4), Map.of(Items.f_42048_, 1, Items.f_42049_, 2, Items.f_42050_, 2, Items.f_42588_, 6), Map.of(Items.f_42102_, 1, Items.f_42730_, 3, Items.f_42584_, 6, Items.f_42748_, 8));
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    protected ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int i) {
            return switch (i) {
                case 0 -> EnergonConverterBlockEntity.this.energy;
                case 1 -> EnergonConverterBlockEntity.this.xpPoints;
                default -> 0;
            };
        }

        public void m_8050_(int i, int i1) {
            switch (i) {
                case 0: {
                    EnergonConverterBlockEntity.this.energy = i1;
                    break;
                }
                case 1: {
                    EnergonConverterBlockEntity.this.xpPoints = i1;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int energy;
    private int xpPoints;
    public float mixerRot;
    public float rotSpeed;

    public EnergonConverterBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.ENERGON_CONVERTER.get(), pos, blockState);
    }

    public static boolean tick(int energy, Level lvl, EnergonConverterBlockEntity blockEntity, float minCoef) {
        if (energy <= 0) {
            blockEntity.rotSpeed *= 0.95f;
            return false;
        }
        if (blockEntity.m_8020_(7).m_41619_() || !blockEntity.m_8020_(0).m_41619_() || blockEntity.m_8020_(1).m_41613_() < 4 || blockEntity.m_8020_(2).m_41619_() || IntStream.range(0, 4).anyMatch(i -> !INGREDIENT_VALUES.get(i).containsKey(blockEntity.m_8020_(i + 3).m_41720_()))) {
            blockEntity.energy = 0;
            blockEntity.rotSpeed *= 0.95f;
            return false;
        }
        blockEntity.energy += energy;
        if (blockEntity.rotSpeed < 2.5f) {
            blockEntity.rotSpeed += 0.0625f;
        }
        if (blockEntity.energy > 9000) {
            int quality = IntStream.range(0, 4).map(i -> INGREDIENT_VALUES.get(i).get(blockEntity.m_8020_(i + 3).m_41720_())).sum();
            ItemStack syringes = blockEntity.m_8020_(7);
            int amount = Math.min(8 + lvl.f_46441_.m_216332_(Math.round(minCoef * (float)quality), 2 * quality), syringes.m_41613_());
            blockEntity.m_6836_(0, new ItemStack((ItemLike)ModItems.SYNTH_EN.get(), amount));
            blockEntity.m_8020_(1).m_41774_(4);
            for (int i2 = 2; i2 < 7; ++i2) {
                ItemStack stack = blockEntity.m_8020_(i2);
                Item remaining = stack.m_41720_().m_41469_();
                stack.m_41774_(1);
                if (!stack.m_41619_() || remaining == null) continue;
                blockEntity.m_6836_(i2, remaining.m_7968_());
            }
            syringes.m_41774_(amount);
            blockEntity.xpPoints += quality;
            blockEntity.energy = 0;
        }
        return true;
    }

    public static void tick(Level lvl, BlockPos pos, BlockState state, EnergonConverterBlockEntity blockEntity) {
        blockEntity.mixerRot += blockEntity.rotSpeed;
        EnergonConverterBlockEntity.tick(lvl.m_277086_(pos), lvl, blockEntity, 1.0f);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.tfp.energon_converter");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new EnergonConverterMenu(id, inventory, (Container)this, this.dataAccess);
    }

    public int m_6643_() {
        return 8;
    }

    public boolean m_7983_() {
        for (ItemStack item : this.items) {
            if (item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack m_7407_(int i, int count) {
        return ContainerHelper.m_18969_(this.items, (int)i, (int)count);
    }

    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.items, (int)i);
    }

    public void m_6836_(int i, ItemStack itemStack) {
        this.items.set(i, (Object)itemStack);
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index <= 0) {
            return false;
        }
        try {
            return INGREDIENT_VALUES.get(index - 3).containsKey(stack.m_41720_());
        }
        catch (IndexOutOfBoundsException e) {
            return stack.m_150930_(switch (index) {
                case 1 -> Items.f_42616_;
                case 2 -> Items.f_42593_;
                default -> ModItems.SYRINGE.get();
            });
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public float getConvertingProcess() {
        return (float)this.energy / 9000.0f;
    }

    public int getXpPoints() {
        return this.xpPoints;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.energy = tag.m_128451_("Energy");
        this.xpPoints = tag.m_128451_("XpPoints");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128405_("Energy", this.energy);
        tag.m_128405_("XpPoints", this.xpPoints);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

