/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.blockentity;

import bnb.tfp.block.EnergonCableBlock;
import bnb.tfp.block.EnergonPowered;
import bnb.tfp.reg.ModBlockEntities;
import bnb.tfp.reg.ModBlocks;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EnergonTankBlockEntity
extends BlockEntity {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private float energonLevel;
    private NonNullList<BlockPos> poweredPositions = NonNullList.m_122779_();

    public EnergonTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public EnergonTankBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.ENERGON_TANK.get(), pos, state);
    }

    public float getEnergonLevel() {
        return this.energonLevel;
    }

    public void setEnergonLevel(float energonLevel) {
        this.energonLevel = Mth.m_14036_((float)energonLevel, (float)0.0f, (float)1.0f);
        this.m_6596_();
    }

    public void tick(Level lvl, BlockPos pos) {
        NonNullList list = NonNullList.m_122779_();
        if (this.getEnergonLevel() > 0.0f) {
            for (Direction direction : DIRECTIONS) {
                if (!lvl.m_8055_(pos.m_121945_(direction)).m_60713_((Block)ModBlocks.ENERGON_CABLE.get())) continue;
                EnergonCableBlock.doToConnectedBlock((LevelAccessor)lvl, pos, direction, (pos1, state1) -> {
                    Block patt2340$temp = state1.m_60734_();
                    if (patt2340$temp instanceof EnergonPowered) {
                        EnergonPowered energonPowered = (EnergonPowered)patt2340$temp;
                        list.add(pos1);
                        if (this.poweredPositions.remove(pos1)) {
                            this.setEnergonLevel(this.getEnergonLevel() - energonPowered.poweredTick(lvl, (BlockPos)pos1, (BlockState)state1));
                        } else {
                            energonPowered.onPowered(lvl, (BlockPos)pos1, (BlockState)state1);
                        }
                    }
                });
            }
        }
        this.unpowerConnectedBlocks(lvl);
        this.poweredPositions = list;
    }

    public void unpowerConnectedBlocks(Level lvl) {
        this.poweredPositions.forEach(pos1 -> {
            BlockState state1 = lvl.m_8055_(pos1);
            Block patt3058$temp = state1.m_60734_();
            if (patt3058$temp instanceof EnergonPowered) {
                EnergonPowered energonPowered = (EnergonPowered)patt3058$temp;
                energonPowered.onUnpowered(lvl, (BlockPos)pos1, state1);
            }
        });
    }

    public boolean fill(Level lvl, BlockPos pos, BlockState state) {
        float newLevel = this.getEnergonLevel() + 0.0625f;
        if (newLevel > 1.0f) {
            return false;
        }
        this.setEnergonLevel(newLevel);
        RandomSource random = lvl.m_213780_();
        lvl.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 0.8f + random.m_188501_() * 0.4f);
        lvl.m_7260_(pos, state, state, 3);
        return true;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("EnergonLevel", this.getEnergonLevel());
        ArrayList list = new ArrayList();
        this.poweredPositions.forEach(pos -> {
            list.add(pos.m_123341_());
            list.add(pos.m_123342_());
            list.add(pos.m_123343_());
        });
        tag.m_128408_("PoweredPositions", list);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energonLevel = tag.m_128457_("EnergonLevel");
        int[] ints = tag.m_128465_("PoweredPositions");
        for (int i = 0; i < ints.length; i += 3) {
            this.poweredPositions.add((Object)new BlockPos(ints[i], ints[i + 1], ints[i + 2]));
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("EnergonLevel", this.getEnergonLevel());
        return tag;
    }
}

