/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.blockentity;

import bnb.tfp.block.GroundBridgeControlBlock;
import bnb.tfp.client.gui.screens.GroundBridgeControlScreen;
import bnb.tfp.entity.GroundBridge;
import bnb.tfp.reg.ModBlockEntities;
import bnb.tfp.reg.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GroundBridgeControlBlockEntity
extends BlockEntity {
    public short animTick = (short)5;
    @Nullable
    private UUID portal1;
    @Nullable
    private UUID portal2;

    public GroundBridgeControlBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.GROUND_BRIDGE_CONTROL.get(), pos, state);
    }

    public void setPortals(GroundBridge portal1, GroundBridge portal2) {
        this.portal1 = portal1.m_20148_();
        this.portal2 = portal2.m_20148_();
        this.m_6596_();
    }

    public void removePortals(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            for (UUID uuid : new UUID[]{this.portal1, this.portal2}) {
                Entity entity;
                if (uuid == null || (entity = lvl.m_8791_(uuid)) == null) continue;
                entity.m_146870_();
                int chunkX = Mth.m_14107_((double)(entity.m_20185_() / 16.0));
                int chunkZ = Mth.m_14107_((double)(entity.m_20189_() / 16.0));
                if (!lvl.m_142425_((EntityTypeTest)ModEntities.GROUND_BRIDGE.get(), new AABB((double)(chunkX * 16), Double.MIN_VALUE, (double)(chunkZ * 16), (double)(chunkX * 16 + 16), 3.4028234663852886E38, (double)(chunkZ * 16 + 16)), entity1 -> true).isEmpty()) continue;
                lvl.m_8602_(chunkX, chunkZ, false);
            }
        }
        this.portal2 = null;
        this.portal1 = null;
    }

    public void use(BlockState state, Level lvl, BlockPos pos, Player player) {
        boolean powered = (Boolean)state.m_61143_((Property)GroundBridgeControlBlock.ENABLED);
        if (powered) {
            this.removePortals(lvl);
            GroundBridgeControlBlock.setEnabled(lvl, pos, state, false);
        } else if (lvl.f_46443_) {
            GroundBridgeControlScreen.openScreen(lvl, pos, player);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.portal1 = tag.m_128441_("Portal1UUID") ? tag.m_128342_("Portal1UUID") : null;
        this.portal2 = tag.m_128441_("Portal2UUID") ? tag.m_128342_("Portal2UUID") : null;
        this.animTick = (short)(tag.m_128471_("Animate") ? 0 : 5);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.portal1 != null) {
            tag.m_128362_("Portal1UUID", this.portal1);
        }
        if (this.portal2 != null) {
            tag.m_128362_("Portal2UUID", this.portal2);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128379_("Animate", true);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

