/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.blockentity;

import bnb.tfp.TFPData;
import bnb.tfp.reg.ModBlockEntities;
import bnb.tfp.reg.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LaptopBlockEntity
extends BlockEntity {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private Optional<UUID> tracked = Optional.empty();
    private BlockPos trackedPos = BlockPos.f_121853_;
    public HashMap<Direction.Axis, Integer> axisTicks = new HashMap<Direction.Axis, Integer>(Map.of(Direction.Axis.X, 0, Direction.Axis.Y, 0, Direction.Axis.Z, 0));

    protected LaptopBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public LaptopBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.LAPTOP.get(), pos, state);
    }

    public static boolean canTrackPlayer(Player player, BlockPos pos) {
        return TFPData.isTransformerStatic((Entity)player) && player.m_20182_().m_82554_(pos.m_252807_()) <= 4096.0;
    }

    public Optional<UUID> getTracked() {
        return this.tracked;
    }

    public BlockPos getTrackedPos() {
        return this.trackedPos;
    }

    public void setTracked(@Nullable UUID tracked) {
        this.tracked = Optional.ofNullable(tracked);
        this.m_6596_();
    }

    public void updateTracking(Level lvl, BlockPos pos) {
        this.tracked.map(arg_0 -> ((Level)lvl).m_46003_(arg_0)).ifPresentOrElse(player -> {
            if (!LaptopBlockEntity.isConnectedToSignalNavigator(lvl, pos) || !LaptopBlockEntity.canTrackPlayer(player, pos)) {
                this.setTracked(null);
            }
            if (this.trackedPos != player.m_20183_()) {
                this.trackedPos = player.m_20183_();
                this.m_6596_();
            }
        }, () -> this.setTracked(null));
        BlockState state = lvl.m_8055_(pos);
        lvl.m_7260_(pos, state, state, 3);
    }

    private static boolean isConnectedToSignalNavigator(Level lvl, BlockPos pos) {
        for (Direction direction : DIRECTIONS) {
            if (!lvl.m_8055_(pos.m_121945_(direction)).m_60713_((Block)ModBlocks.SIGNAL_NAVIGATOR.get())) continue;
            return true;
        }
        return false;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.tracked.ifPresent(uuid -> tag.m_128362_("Tracked", uuid));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        Optional<Object> optional = this.tracked = tag.m_128441_("Tracked") ? Optional.of(tag.m_128342_("Tracked")) : Optional.empty();
        if (tag.m_128441_("TrackedPos")) {
            int[] pos = tag.m_128465_("TrackedPos");
            if (this.getTrackedPos().m_123341_() != pos[0]) {
                this.axisTicks.put(Direction.Axis.X, 0);
            }
            if (this.getTrackedPos().m_123342_() != pos[1]) {
                this.axisTicks.put(Direction.Axis.Y, 0);
            }
            if (this.getTrackedPos().m_123343_() != pos[2]) {
                this.axisTicks.put(Direction.Axis.Z, 0);
            }
            this.trackedPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128385_("TrackedPos", new int[]{this.trackedPos.m_123341_(), this.trackedPos.m_123342_(), this.trackedPos.m_123343_()});
        return tag;
    }
}

