/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client;

import bnb.tfp.client.TransformerEngineSoundInstance;
import bnb.tfp.client.animation.AnimPair;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerSounds;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ClientUtils {
    public static final AnimationDefinition NO_ANIMATION = AnimationDefinition.Builder.m_232275_((float)0.0f).m_232282_();
    public static final AnimPair NO_ANIM_PAIR = AnimPair.ofSame(NO_ANIMATION);

    public static AnimationDefinition changeChannels(AnimationDefinition original, BiFunction<String, AnimationChannel, AnimationChannel> biFunction) {
        AnimationDefinition.Builder builder = AnimationDefinition.Builder.m_232275_((float)original.f_232255_());
        if (original.f_232256_()) {
            builder.m_232274_();
        }
        Map anims = original.f_232257_();
        anims.forEach((bone, channels) -> channels.forEach(channel -> {
            AnimationChannel channel1 = (AnimationChannel)biFunction.apply((String)bone, (AnimationChannel)channel);
            if (channel1 != null) {
                builder.m_232279_(bone, channel1);
            }
        }));
        return builder.m_232282_();
    }

    public static AnimationDefinition reversedAnim(AnimationDefinition original) {
        return ClientUtils.changeChannels(original, (bone, channel) -> {
            int keyframeNumber = channel.f_232212_().length;
            Keyframe[] keyframes = new Keyframe[keyframeNumber];
            for (int i = 0; i < keyframeNumber; ++i) {
                Keyframe keyframe = channel.f_232212_()[i];
                keyframes[keyframeNumber - i - 1] = new Keyframe(original.f_232255_() - keyframe.f_232283_(), keyframe.f_232284_(), keyframe.f_232285_());
            }
            return new AnimationChannel(channel.f_232211_(), keyframes);
        });
    }

    public static AnimationDefinition withoutBones(AnimationDefinition original, Predicate<String> predicate) {
        return ClientUtils.changeChannels(original, (bone, channel) -> predicate.test((String)bone) ? channel : null);
    }

    public static AnimationDefinition withoutBonesWithSubstringsInName(AnimationDefinition original, String ... substrings) {
        return ClientUtils.withoutBones(original, string -> {
            for (String substring : substrings) {
                if (!string.contains(substring)) continue;
                return false;
            }
            return true;
        });
    }

    public static AnimationDefinition removePose(AnimationDefinition original, AnimationDefinition pose, IntUnaryOperator index) {
        return ClientUtils.changeChannels(original, (bone, channel) -> {
            AnimationChannel channel2;
            AnimationChannel.Target target = channel.f_232211_();
            List channels = (List)pose.f_232257_().get(bone);
            if (channels != null && (channel2 = (AnimationChannel)channels.stream().filter(channel1 -> channel1.f_232211_() == target).findFirst().orElse(null)) != null) {
                Keyframe[] origKeyframes = channel2.f_232212_();
                Vector3f vector3f = origKeyframes[index.applyAsInt(origKeyframes.length)].f_232284_();
                Keyframe[] keyframes = channel.f_232212_();
                Keyframe[] keyframes1 = new Keyframe[keyframes.length];
                for (int i = 0; i < keyframes.length; ++i) {
                    Keyframe keyframe = keyframes[i];
                    keyframes1[i] = new Keyframe(keyframe.f_232283_(), new Vector3f().add((Vector3fc)keyframe.f_232284_()).sub((Vector3fc)vector3f), keyframe.f_232285_());
                }
                return new AnimationChannel(channel.f_232211_(), keyframes1);
            }
            return channel;
        });
    }

    public static AnimationDefinition removePose(AnimationDefinition original, AnimationDefinition pose) {
        return ClientUtils.removePose(original, pose, size -> 0);
    }

    public static AnimationDefinition removePoseSelf(AnimationDefinition animation) {
        return ClientUtils.removePose(animation, animation);
    }

    public static AnimationDefinition removePoseLast(AnimationDefinition original, AnimationDefinition pose) {
        return ClientUtils.removePose(original, pose, size -> size - 1);
    }

    public static AnimationDefinition swapRightLeft(AnimationDefinition original) {
        AnimationDefinition.Builder builder = AnimationDefinition.Builder.m_232275_((float)original.f_232255_());
        if (original.f_232256_()) {
            builder.m_232274_();
        }
        Map anims = original.f_232257_();
        anims.forEach((bone, channels) -> channels.forEach(channel -> {
            AnimationChannel.Target target = channel.f_232211_();
            String bone1 = bone;
            if (bone.contains("Right")) {
                bone1 = bone.replace("Right", "Left");
            } else if (bone.contains("right")) {
                bone1 = bone.replace("right", "left");
            } else if (bone.contains("Left")) {
                bone1 = bone.replace("Left", "Right");
            } else if (bone.contains("left")) {
                bone1 = bone.replace("left", "right");
            }
            builder.m_232279_(bone1, new AnimationChannel(channel.f_232211_(), (Keyframe[])Arrays.stream(channel.f_232212_()).map(keyframe -> {
                Vector3f vector3f1 = new Vector3f((Vector3fc)keyframe.f_232284_());
                if (target == AnimationChannel.Targets.f_232250_) {
                    vector3f1.mul(-1.0f, 1.0f, 1.0f);
                } else if (target == AnimationChannel.Targets.f_232251_) {
                    vector3f1.mul(1.0f, -1.0f, -1.0f);
                }
                return new Keyframe(keyframe.f_232283_(), vector3f1, keyframe.f_232285_());
            }).toArray(Keyframe[]::new)));
        }));
        return builder.m_232282_();
    }

    public static void playTransformerEngineSound(PlayableTransformer transformer, Player player) {
        transformer.getSounds().getSound(TransformerSounds.Sound.ENGINE).ifPresent(soundEvent -> Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new TransformerEngineSoundInstance((SoundEvent)soundEvent, (AbstractClientPlayer)player)));
    }
}

