/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client;

import bnb.tfp.TFPData;
import bnb.tfp.network.TransformerActionPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.PlayableTransformer;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;

public class ModKeys {
    private static final int cooldown = 10;
    private static int transformTick;
    private static int weaponLoadTick;
    private static int gunLoadTick;
    private static int specialTick;
    public static final KeyMapping keyTransform;
    public static final KeyMapping keyLoadGun;
    public static final KeyMapping keyLoadWeapon;
    public static final KeyMapping keySpecial;

    public static void init(Consumer<KeyMapping> consumer) {
        consumer.accept(keyTransform);
        consumer.accept(keyLoadGun);
        consumer.accept(keyLoadWeapon);
        consumer.accept(keySpecial);
    }

    public static void keyPressed() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        TFPData tfpData = TFPData.clientInstance();
        PlayableTransformer transformer = tfpData.getTransformer((Player)player);
        if (transformer == null) {
            return;
        }
        int transformProcess = player.f_19797_ - transformTick;
        int loadProcess = player.f_19797_ - Math.max(weaponLoadTick, gunLoadTick);
        boolean canLoad = loadProcess >= 10 || loadProcess < 0;
        int specialProcess = player.f_19797_ - specialTick;
        if (keyTransform.m_90859_() && (transformProcess >= 10 || transformProcess < 0)) {
            ModNetworking.sendToServer(new TransformerActionPacket(TransformerActionPacket.Action.TRANSFORM));
        }
        if (keyLoadWeapon.m_90859_() && canLoad && transformer.canUseWeapon((Player)player)) {
            ModNetworking.sendToServer(new TransformerActionPacket(TransformerActionPacket.Action.WEAPON));
        }
        if (keyLoadGun.m_90859_() && canLoad && transformer.canUseGun((Player)player)) {
            ModNetworking.sendToServer(new TransformerActionPacket(TransformerActionPacket.Action.GUN));
        }
        if (keySpecial.m_90859_() && transformer.canUseSpecial((Player)player) && (specialProcess >= 10 || specialProcess < 0)) {
            ModNetworking.sendToServer(new TransformerActionPacket(TransformerActionPacket.Action.SPECIAL));
        }
    }

    public static void actionCooldown(TransformerActionPacket.Action action) {
        LocalPlayer player = Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        int ticks = player.f_19797_;
        switch (action) {
            case TRANSFORM: {
                transformTick = ticks;
                break;
            }
            case WEAPON: {
                weaponLoadTick = ticks;
                if (!TFPData.clientInstance().getTransformer((Player)player).isUsingGun((Player)player)) break;
                gunLoadTick = ticks;
                break;
            }
            case GUN: {
                gunLoadTick = ticks;
                break;
            }
            case SPECIAL: {
                specialTick = ticks;
            }
        }
    }

    static {
        keyTransform = new KeyMapping("key.tfp.transform", 82, "key.categories.tfp.transformer");
        keyLoadGun = new KeyMapping("key.tfp.gun", 90, "key.categories.tfp.transformer");
        keyLoadWeapon = new KeyMapping("key.tfp.weapon", 71, "key.categories.tfp.transformer");
        keySpecial = new KeyMapping("key.tfp.special", 86, "key.categories.tfp.transformer");
    }
}

