/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.gui;

import bnb.tfp.TFPData;
import bnb.tfp.transformer.PlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModGui {
    public static final ResourceLocation TRANSFORMER_ICONS_LOCATION = new ResourceLocation("tfp", "textures/gui/transformer_icons.png");

    public static void renderSpeedometer(Player player, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        PlayableTransformer transformer = TFPData.getTransformerStatic(player);
        if (transformer == null) {
            return;
        }
        if (transformer.getVehicleType().shouldShowSpeedometer(player, transformer)) {
            guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, width / 2 + 10, height - 62, 16, 0, 26, 21);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(width / 2 + 23), (float)(height - 47), 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252961_((float)(-Math.PI) * Mth.m_14036_((float)(1.0f - (float)transformer.getVehicleType().speedometerValue(player, transformer, player.m_20182_().m_82492_(player.f_19790_, player.f_19791_, player.f_19792_).m_165921_(player.m_20184_(), (double)partialTick))), (float)0.0f, (float)1.0f)));
            guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, -1, -1, 42, 0, 11, 2);
            poseStack.m_85849_();
        }
    }

    public static void renderEnergonBar(GuiGraphics guiGraphics, ProfilerFiller profiler, Player player, PlayableTransformer transformer, RandomSource random, int tickCount, int screenWidth, int screenHeight) {
        profiler.m_6180_("energon");
        for (int i4 = 0; i4 < 10; ++i4) {
            int l = player.m_36324_().m_38702_();
            int j4 = screenHeight - 39;
            if (player.m_36324_().m_38722_() <= 0.0f && tickCount % (l * 3 + 1) == 0) {
                j4 += random.m_188503_(3) - 1;
            }
            int i5 = screenWidth / 2 - i4 * 8 + 82;
            guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, i5, j4, player.m_21023_(MobEffects.f_19612_) ? 43 : 16, 27, 9, 9);
            float[] color = transformer.getGlowingColor(player);
            guiGraphics.m_280246_(color[0], color[1], color[2], 1.0f);
            if (i4 * 2 + 1 < l) {
                guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, i5, j4, 25, 27, 9, 9);
            }
            if (i4 * 2 + 1 == l) {
                guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, i5, j4, 34, 27, 9, 9);
            }
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
        profiler.m_7238_();
    }

    public static void renderCrosshair(Minecraft mc, GuiGraphics guiGraphics, Player player, PlayableTransformer transformer, int width, int height) {
        if (mc.f_91066_.m_92176_().m_90612_()) {
            float[] color = transformer.getGlowingColor(player);
            int x = (width - 15) / 2;
            int y = (height - 15) / 2;
            int vOffset = transformer.isUsingGun(player) ? 16 : (transformer.isUsingWeapon(player) ? 32 : 0);
            int vHeight = Mth.m_14167_((float)((1.0f - player.m_36403_(0.0f)) * 15.0f));
            if (vHeight > 0) {
                guiGraphics.m_280246_(color[0], color[1], color[2], 0.25f);
                guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, x, y, 0, vOffset, 15, vHeight);
            }
            if (vHeight < 15) {
                guiGraphics.m_280246_(color[0], color[1], color[2], mc.f_91076_ != null ? 0.75f : 0.5f);
                guiGraphics.m_280218_(TRANSFORMER_ICONS_LOCATION, x, y + vHeight, 0, vOffset + vHeight, 15, 15 - vHeight);
            }
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

