/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.gui.screens;

import bnb.tfp.network.CreateGroundBridgePacket;
import bnb.tfp.reg.ModBlocks;
import bnb.tfp.reg.ModNetworking;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GroundBridgeControlScreen
extends Screen {
    private static final int margin = 75;
    private static final Component X_LABEL = Component.m_237113_((String)"X:");
    private static final Component Y_LABEL = Component.m_237113_((String)"Y:");
    private static final Component Z_LABEL = Component.m_237113_((String)"Z:");
    private final Level lvl;
    private final BlockPos pos;
    private final Player player;
    private EditBox setX;
    private EditBox setY;
    private EditBox setZ;
    private Button groundBridge;
    private int x;
    private int y;
    private int z;

    public GroundBridgeControlScreen(Level lvl, BlockPos pos, Player player) {
        super((Component)ModBlocks.GROUND_BRIDGE_CONTROL.get().m_49954_());
        this.lvl = lvl;
        this.pos = pos;
        this.player = player;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setX = this.addCoordInput(10, X_LABEL, this.x);
        this.setY = this.addCoordInput(40, Y_LABEL, this.y);
        this.setZ = this.addCoordInput(70, Z_LABEL, this.z);
        this.groundBridge = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"tfp.ground_bridge_control.ground_bridge"), button -> {
            for (int x1 = this.pos.m_123341_() - 8; x1 <= this.pos.m_123341_() + 8; ++x1) {
                for (int y1 = this.pos.m_123342_() - 8; y1 <= this.pos.m_123342_() + 8; ++y1) {
                    for (int z1 = this.pos.m_123343_() - 8; z1 <= this.pos.m_123343_() + 8; ++z1) {
                        BlockPos pos1 = new BlockPos(x1, y1, z1);
                        Direction facing = GroundBridgeControlScreen.defineGroundBridgeDirectionIfPossible(pos1, this.lvl);
                        if (facing == null) continue;
                        ModNetworking.sendToServer(new CreateGroundBridgePacket(pos1.m_7494_(), facing, new BlockPos(this.x, this.y, this.z), this.pos));
                        this.m_7379_();
                        return;
                    }
                }
            }
            this.player.m_5661_((Component)Component.m_237115_((String)"tfp.ground_bridge_control.frame_not_found"), true);
            this.m_7379_();
        }).m_252987_(this.f_96543_ - 150 - 75, this.f_96544_ - 30, 150, 20).m_253136_());
        this.groundBridge.f_93623_ = false;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252987_(75, this.f_96544_ - 30, 150, 20).m_253136_());
    }

    public static void openScreen(Level lvl, BlockPos pos, Player player) {
        Minecraft.m_91087_().m_91152_((Screen)new GroundBridgeControlScreen(lvl, pos, player));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.drawCoordLabel(graphics, X_LABEL, this.setX);
        this.drawCoordLabel(graphics, Y_LABEL, this.setY);
        this.drawCoordLabel(graphics, Z_LABEL, this.setZ);
    }

    private EditBox addCoordInput(int screenY, Component label, int defaultValue) {
        EditBox output = new EditBox(this.f_96547_, this.f_96543_ - 300 - 75, screenY, 300, 20, label);
        output.m_94199_(32);
        output.m_94144_(String.valueOf(defaultValue));
        output.m_94151_(value -> this.update());
        return (EditBox)this.m_142416_((GuiEventListener)output);
    }

    private void drawCoordLabel(GuiGraphics graphics, Component label, EditBox box) {
        graphics.m_280430_(this.f_96547_, label, box.m_252754_() / 2, box.m_252907_() + box.m_93694_() / 2, 0xA0A0A0);
    }

    private void update() {
        try {
            this.x = Integer.parseInt(this.setX.m_94155_());
            this.y = Integer.parseInt(this.setY.m_94155_());
            this.z = Integer.parseInt(this.setZ.m_94155_());
            this.groundBridge.f_93623_ = Level.m_46741_((BlockPos)new BlockPos(this.x, this.y, this.z));
        }
        catch (NumberFormatException e) {
            this.groundBridge.f_93623_ = false;
        }
    }

    @Nullable
    public static Direction defineGroundBridgeDirectionIfPossible(BlockPos pos, Level lvl) {
        if (GroundBridgeControlScreen.checkFrame(pos, lvl, Direction.NORTH) && GroundBridgeControlScreen.checkFrame(pos, lvl, Direction.SOUTH)) {
            return Direction.WEST;
        }
        if (GroundBridgeControlScreen.checkFrame(pos, lvl, Direction.WEST) && GroundBridgeControlScreen.checkFrame(pos, lvl, Direction.EAST)) {
            return Direction.NORTH;
        }
        return null;
    }

    private static boolean checkFrame(BlockPos pos, Level lvl, Direction direction) {
        BlockPos pos1 = new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        Direction opposite = direction.m_122424_();
        for (List<Direction> directions : List.of(List.of(), List.of(direction), List.of(direction, Direction.UP), List.of(direction, Direction.UP), List.of(Direction.UP), List.of(Direction.UP), List.of(opposite, Direction.UP), List.of(opposite, Direction.UP), List.of(opposite))) {
            for (Direction i : directions) {
                pos1 = pos1.m_121945_(i);
            }
            if (lvl.m_8055_(pos1).m_60713_(ModBlocks.CYBERMATTER.get())) continue;
            return false;
        }
        BlockPos i = pos.m_7494_();
        while (i.m_123342_() <= pos.m_123342_() + 5) {
            if (!lvl.m_8055_(i).m_60795_() || !lvl.m_8055_(i.m_121945_(direction)).m_60795_()) {
                return false;
            }
            i = i.m_7494_();
        }
        i = pos.m_5484_(direction, 2).m_6630_(2);
        while (i.m_123342_() <= pos.m_123342_() + 4) {
            if (!lvl.m_8055_(i).m_60795_()) {
                return false;
            }
            i = i.m_7494_();
        }
        return true;
    }
}

