/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.gui.screens;

import bnb.tfp.TFPData;
import bnb.tfp.network.SetTransformerPacket;
import bnb.tfp.reg.ModNetworking;
import bnb.tfp.transformer.HSBColor;
import bnb.tfp.transformer.PlayableTransformer;
import bnb.tfp.transformer.TransformerColorLayer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransformerEditorScreen
extends Screen {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("tfp", "textures/gui/transformer_editor.png");
    private static final Component NO_LAYERS_COMPONENT = Component.m_237115_((String)"gui.tfp.transformer_editor.no_layers").m_130940_(ChatFormatting.WHITE);
    private static final Component FACTION_COMPONENT = Component.m_237115_((String)"gui.tfp.transformer_editor.faction").m_130940_(ChatFormatting.WHITE);
    private static final Component PASSENGERS_LIMIT_COMPONENT = Component.m_237115_((String)"gui.tfp.transformer_editor.passengers_limit").m_130940_(ChatFormatting.WHITE);
    private static final Component MINER_MODE_COMPONENT = Component.m_237115_((String)"gui.tfp.transformer_editor.miner_mode").m_130940_(ChatFormatting.WHITE);
    private static final Component F5_VEHICLE = Component.m_237115_((String)"gui.tfp.transformer_editor.f5_vehicle").m_130940_(ChatFormatting.WHITE);
    private final PlayableTransformer edited;
    @Nullable
    private TransformerColorLayer layer;
    @Nullable
    private ArrayDeque<HSBColor> originalColors;
    private final PlayableTransformer.Faction originalFaction;
    private final byte originalPassengersLimit;
    private final ArrayList<ColorButton> colorButtons;
    private BrightnessScrollWidget brightnessScrollWidget;
    private boolean rotating;
    private float yRot;
    private float yRotStep;

    public TransformerEditorScreen(PlayableTransformer transformer) {
        super((Component)Component.m_237115_((String)"gui.tfp.transformer_editor"));
        this.edited = transformer;
        if (!this.edited.getVariant().isEmpty()) {
            this.layer = this.edited.getVariant().get(0);
        }
        this.originalColors = new ArrayDeque<HSBColor>(this.edited.getColors());
        this.originalFaction = this.edited.getFaction();
        this.originalPassengersLimit = this.edited.getPassengersLimit();
        this.colorButtons = new ArrayList();
    }

    protected void m_7856_() {
        super.m_7856_();
        int leftBorder = (this.f_96543_ - 202) / 2;
        for (int hue = 0; hue < 24; ++hue) {
            for (int saturation = 8; saturation >= 0; --saturation) {
                this.colorButtons.add((ColorButton)this.m_142416_((GuiEventListener)new ColorButton(leftBorder + 87 + hue * 4, 87 - saturation * 4, new HSBColor(hue, saturation, 8))));
            }
        }
        if (this.layer != null) {
            this.brightnessScrollWidget = (BrightnessScrollWidget)this.m_142416_((GuiEventListener)new BrightnessScrollWidget(leftBorder + 87, 95));
            this.m_142416_((GuiEventListener)new ChangeLayerButton(leftBorder + 86, 38, false));
            this.m_142416_((GuiEventListener)new ChangeLayerButton(leftBorder + 174, 38, true));
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> {
            ModNetworking.sendToServer(new SetTransformerPacket(this.edited));
            this.originalColors = null;
            this.m_7379_();
        }).m_252987_(leftBorder + 130, 174, 64, 16).m_253136_());
        this.m_142416_((GuiEventListener)new FactionButton(leftBorder + this.f_96547_.m_92852_((FormattedText)FACTION_COMPONENT) + 87, 111));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)(this.edited.isMinerMode() ? "options.on" : "options.off")), button -> {
            this.edited.setMinerMode(!this.edited.isMinerMode());
            button.m_93666_((Component)Component.m_237115_((String)(this.edited.isMinerMode() ? "options.on" : "options.off")));
        }).m_252987_(leftBorder + this.f_96547_.m_92852_((FormattedText)MINER_MODE_COMPONENT) + 87, 128, 32, 12).m_253136_());
        if (this.edited.getType().getMaxPassengers() > 0) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(this.edited.getPassengersLimit())), button -> {
                byte passengers = this.edited.getPassengersLimit();
                if ((passengers = (byte)(passengers + 1)) > this.edited.getType().getMaxPassengers() || passengers < 0) {
                    passengers = 0;
                }
                this.edited.setPassengersLimit(passengers);
                button.m_93666_((Component)Component.m_237113_((String)String.valueOf(passengers)));
            }).m_252987_(leftBorder + this.f_96547_.m_92852_((FormattedText)PASSENGERS_LIMIT_COMPONENT) + 87, 141, 20, 12).m_253136_());
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)(this.edited.getF5Vehicle() ? "options.on" : "options.off")), button -> {
            this.edited.setF5Vehicle(!this.edited.getF5Vehicle());
            button.m_93666_((Component)Component.m_237115_((String)(this.edited.getF5Vehicle() ? "options.on" : "options.off")));
        }).m_252987_(leftBorder + this.f_96547_.m_92852_((FormattedText)F5_VEHICLE) + 87, 154, 32, 12).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int cursorX, int cursorY, float partialTick) {
        this.m_280273_(graphics);
        assert (this.f_96541_ != null);
        int leftBorder = (this.f_96543_ - 202) / 2;
        Component component = this.layer != null ? this.layer.getComponent() : NO_LAYERS_COMPONENT;
        graphics.m_280614_(this.f_96547_, component, leftBorder + 134 - this.f_96547_.m_92852_((FormattedText)component) / 2, 39, 0, false);
        this.yRotStep *= 0.95f;
        this.yRot += this.yRotStep;
        TransformerEditorScreen.renderEntity(graphics, leftBorder + 39, 156, 64, 118, this.yRot, (LivingEntity)Objects.requireNonNull(this.f_96541_.f_91074_));
        graphics.m_280614_(this.f_96547_, FACTION_COMPONENT, leftBorder + 87, 111, 0, false);
        graphics.m_280614_(this.f_96547_, MINER_MODE_COMPONENT, leftBorder + 87, 128, 0, false);
        graphics.m_280614_(this.f_96547_, F5_VEHICLE, leftBorder + 87, 154, 0, false);
        if (this.edited.getType().getMaxPassengers() > 0) {
            graphics.m_280614_(this.f_96547_, PASSENGERS_LIMIT_COMPONENT, leftBorder + 87, 141, 0, false);
        }
        super.m_88315_(graphics, cursorX, cursorY, partialTick);
    }

    public void m_280273_(GuiGraphics graphics) {
        super.m_280273_(graphics);
        graphics.m_280218_(BG_TEXTURE, (this.f_96543_ - 202) / 2, 32, 0, 0, 202, 166);
    }

    public static void renderEntity(GuiGraphics graphics, int x, int y, int windowWidth, int windowHeight, float yRot, LivingEntity entity) {
        float yBodyRot = entity.f_20883_;
        float yRot1 = entity.m_146908_();
        float xRot = entity.m_146909_();
        float yHeadRotO = entity.f_20886_;
        float yHeadRot = entity.f_20885_;
        entity.f_20883_ = 180.0f + yRot;
        entity.m_146922_(180.0f + yRot);
        entity.m_146926_(0.0f);
        entity.f_20886_ = 180.0f + yRot;
        entity.f_20885_ = 180.0f + yRot;
        InventoryScreen.m_280432_((GuiGraphics)graphics, (int)x, (int)y, (int)((int)Math.min((double)((float)windowWidth / entity.m_20205_()) / 2.5, (double)((float)windowHeight / entity.m_20206_()))), (Quaternionf)new Quaternionf().rotateZ((float)Math.PI), null, (LivingEntity)entity);
        entity.f_20883_ = yBodyRot;
        entity.m_146922_(yRot1);
        entity.m_146926_(xRot);
        entity.f_20886_ = yHeadRotO;
        entity.f_20885_ = yHeadRot;
    }

    public boolean m_6375_(double x, double y, int button) {
        int leftBorder = (this.f_96543_ - 202) / 2;
        if (x > (double)(leftBorder + 7) && x < (double)(leftBorder + 71) && y > 39.0 && y < 158.0) {
            this.rotating = true;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        if (this.rotating) {
            this.rotating = false;
            return true;
        }
        return super.m_6348_(x, y, button);
    }

    public boolean m_7979_(double cursorX, double cursorY, int button, double draggedX, double draggedY) {
        if (this.rotating) {
            this.yRotStep -= (float)draggedX * 0.1f;
        }
        return super.m_7979_(cursorX, cursorY, button, draggedX, draggedY);
    }

    public void m_7379_() {
        if (this.originalColors != null) {
            this.edited.getVariant().forEach(layer -> layer.setColor(this.originalColors.poll()));
            this.edited.setFaction(this.originalFaction);
            this.edited.setPassengersLimit(this.originalPassengersLimit);
        }
        super.m_7379_();
    }

    protected class ColorButton
    extends AbstractWidget {
        private HSBColor color;

        public ColorButton(int x, int y, HSBColor color) {
            super(x, y, 4, 4, (Component)Component.m_237115_((String)"gui.tfp.transformer_editor.color"));
            this.color = color;
            this.update();
        }

        public void setBrightness(int brightness) {
            this.color = this.color.copyWithBrightness(brightness);
        }

        public void update() {
            if (TransformerEditorScreen.this.layer != null) {
                ArrayList<HSBColor> variant = new ArrayList<HSBColor>(TransformerEditorScreen.this.edited.getVariant().stream().map(TransformerColorLayer::getColor).toList());
                variant.set(variant.indexOf(TransformerEditorScreen.this.layer.getColor()), this.color);
                this.f_93624_ = TransformerEditorScreen.this.edited.getType().canUseVariant(TFPData.clientInstance(), variant, Objects.requireNonNull(Objects.requireNonNull(((TransformerEditorScreen)TransformerEditorScreen.this).f_96541_).f_91074_).m_20148_());
            }
        }

        public void m_5716_(double cursorX, double cursorY) {
            if (this.f_93624_ && TransformerEditorScreen.this.layer != null) {
                TransformerEditorScreen.this.layer.setColor(this.color);
            }
        }

        protected void m_168797_(NarrationElementOutput var1) {
        }

        protected void m_87963_(GuiGraphics graphics, int cursorX, int cursorY, float partialTick) {
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, TransformerEditorScreen.this.layer == null || !TransformerEditorScreen.this.layer.getColor().equals(this.color) ? this.color.argb : FastColor.ARGB32.m_269105_((float)Mth.m_14154_((float)Mth.m_14031_((float)((float)Util.m_137550_() * (float)Math.PI / 2000.0f))), (int)this.color.argb, (int)(this.color.argb == -1 ? -4210753 : -1)));
        }
    }

    protected class BrightnessScrollWidget
    extends AbstractWidget {
        public static final ResourceLocation SCROLL_LOCATION = new ResourceLocation("tfp", "textures/gui/sprites/transformer_editor/brightness_scroll.png");
        public static final ResourceLocation SLIDER_LOCATION = new ResourceLocation("tfp", "textures/gui/sprites/transformer_editor/brightness_slider.png");
        private int value;

        public BrightnessScrollWidget(int x, int y) {
            super(x, y, 96, 8, (Component)Component.m_237115_((String)"gui.tfp.transformer_editor.change_brightness"));
            this.value = 8;
        }

        protected void m_87963_(GuiGraphics graphics, int cursorX, int cursorY, float partialTick) {
            float[] rgb = Objects.requireNonNull(TransformerEditorScreen.this.layer).getColor().copyWithBrightness(7).rgbFloats();
            graphics.m_280246_(rgb[0], rgb[1], rgb[2], 1.0f);
            graphics.m_280163_(SCROLL_LOCATION, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 96, 8, 96, 8);
            graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.m_280163_(SLIDER_LOCATION, this.m_252754_() + this.value * 12 - 8, this.m_252907_() - 1, 0.0f, 0.0f, 4, 10, 4, 10);
        }

        protected void m_7212_(double cursorX, double cursorY, double draggedX, double draggedY) {
            if (this.f_93624_ && this.setBrightness(Mth.m_14045_((int)((int)((cursorX - (double)this.m_252754_()) / 12.0) + 1), (int)1, (int)8))) {
                TransformerEditorScreen.this.colorButtons.forEach(ColorButton::update);
            }
            super.m_7212_(cursorX, cursorY, draggedX, draggedY);
        }

        public boolean setBrightness(int value) {
            if (value == this.value) {
                return false;
            }
            this.value = value;
            TransformerEditorScreen.this.colorButtons.forEach(colorButton -> colorButton.setBrightness(value));
            return true;
        }

        protected void m_168797_(NarrationElementOutput var1) {
            this.m_168802_(var1);
        }
    }

    protected class ChangeLayerButton
    extends AbstractWidget {
        private final boolean forward;
        public static final ResourceLocation NEXT_TEXTURE = new ResourceLocation("tfp", "textures/gui/sprites/transformer_editor/next.png");
        public static final ResourceLocation NEXT_HIGHLIGHTED_TEXTURE = new ResourceLocation("tfp", "textures/gui/sprites/transformer_editor/next_highlighted.png");
        public static final ResourceLocation PREVIOUS_TEXTURE = new ResourceLocation("tfp", "textures/gui/sprites/transformer_editor/previous.png");
        public static final ResourceLocation PREVIOUS_HIGHLIGHTED_TEXTURE = new ResourceLocation("tfp", "textures/gui/sprites/transformer_editor/previous_highlighted.png");

        public ChangeLayerButton(int x, int y, boolean forward) {
            super(x, y, 10, 10, (Component)Component.m_237115_((String)"gui.tfp.transformer_editor.change_layer"));
            this.forward = forward;
        }

        protected void m_87963_(GuiGraphics graphics, int cursorX, int cursorY, float partialTick) {
            graphics.m_280163_(this.forward ? (this.m_198029_() ? NEXT_HIGHLIGHTED_TEXTURE : NEXT_TEXTURE) : (this.m_198029_() ? PREVIOUS_HIGHLIGHTED_TEXTURE : PREVIOUS_TEXTURE), this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 10, 10, 10, 10);
        }

        public void m_5716_(double cursorX, double cursorY) {
            List<TransformerColorLayer> layers = TransformerEditorScreen.this.edited.getVariant();
            int index = layers.indexOf(TransformerEditorScreen.this.layer);
            if ((this.forward ? ++index : --index) < 0) {
                index = layers.size() - 1;
            } else if (index >= layers.size()) {
                index = 0;
            }
            TransformerEditorScreen.this.layer = layers.get(index);
            if (TransformerEditorScreen.this.layer.brightColorsOnly()) {
                TransformerEditorScreen.this.brightnessScrollWidget.f_93624_ = false;
                TransformerEditorScreen.this.brightnessScrollWidget.setBrightness(8);
            } else {
                TransformerEditorScreen.this.brightnessScrollWidget.f_93624_ = true;
            }
            TransformerEditorScreen.this.colorButtons.forEach(ColorButton::update);
        }

        protected void m_168797_(NarrationElementOutput var1) {
            this.m_168802_(var1);
        }
    }

    protected class FactionButton
    extends AbstractWidget {
        public final ResourceLocation AUTOBOTS_TEXTURE;
        public final ResourceLocation DECEPTICONS_TEXTURE;

        public FactionButton(int x, int y) {
            super(x, y, 16, 16, FACTION_COMPONENT);
            this.AUTOBOTS_TEXTURE = new ResourceLocation("tfp", "textures/item/autobots_icon.png");
            this.DECEPTICONS_TEXTURE = new ResourceLocation("tfp", "textures/item/decepticons_icon.png");
        }

        protected void m_87963_(GuiGraphics graphics, int cursorX, int cursorY, float partialTick) {
            boolean autobot = TransformerEditorScreen.this.edited.getFaction() == PlayableTransformer.Faction.AUTOBOTS;
            graphics.m_280163_(autobot ? this.AUTOBOTS_TEXTURE : this.DECEPTICONS_TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 16, 16, 16, 16);
            if (this.m_274382_()) {
                graphics.m_280245_(TransformerEditorScreen.this.f_96547_, List.of((autobot ? PlayableTransformer.Faction.AUTOBOTS : PlayableTransformer.Faction.DECEPTICONS).getComponent().m_7532_(), Component.m_237115_((String)"gui.tfp.transformer_editor.click2change").m_7532_()), cursorX, cursorY);
            }
        }

        public void m_5716_(double cursorX, double cursorY) {
            TransformerEditorScreen.this.edited.setFaction(TransformerEditorScreen.this.edited.getFaction() == PlayableTransformer.Faction.AUTOBOTS ? PlayableTransformer.Faction.DECEPTICONS : PlayableTransformer.Faction.AUTOBOTS);
        }

        protected void m_168797_(NarrationElementOutput var1) {
            this.m_168802_(var1);
        }
    }
}

