/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model;

import bnb.tfp.client.animation.ScrapletAnimation;
import bnb.tfp.entity.Scraplet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ScrapletModel<T extends Scraplet>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfp", "scraplet"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public ScrapletModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("Scraplet").m_171324_("Body").m_171324_("Neck").m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Scraplet2 = partdefinition.m_171599_("Scraplet", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Body = Scraplet2.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(22, 5).m_171488_(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition Neck = Body.m_171599_("Neck", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition Head = Neck.m_171599_("Head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.4446f, (float)-1.4806f));
        PartDefinition TopJaw = Head.m_171599_("TopJaw", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -4.0506f, -4.9744f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 14).m_171488_(-2.5f, -1.0507f, -4.9744f, 5.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(-5, 35).m_171488_(-3.0f, -1.0507f, -4.9744f, 6.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(6, 30).m_171488_(-2.5f, -1.0507f, -3.9744f, 5.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(8, 31).m_171488_(-1.5f, -1.0507f, -2.9743f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.3821f, (float)1.4181f));
        PartDefinition RightHeadPanel = TopJaw.m_171599_("RightHeadPanel", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-3.0f, 0.0f, -5.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(6, 26).m_171488_(-2.5f, 0.0f, -5.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)3.0f, (float)-4.0506f, (float)0.0256f));
        PartDefinition LeftHeadPanel = TopJaw.m_171599_("LeftHeadPanel", CubeListBuilder.m_171558_().m_171514_(18, 16).m_171488_(0.0f, 0.0f, -5.0f, 3.0f, 4.0f, 6.0f, new CubeDeformation(0.01f)).m_171514_(12, 26).m_171488_(1.5f, 0.0f, -5.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)-3.0f, (float)-4.0506f, (float)0.0256f));
        PartDefinition BottomJaw = Head.m_171599_("BottomJaw", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171488_(-3.0f, -1.0f, -5.0f, 6.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(6, 14).m_171488_(-2.5f, -1.0f, -5.0f, 5.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(6, 30).m_171488_(-2.5f, -1.0f, -4.0f, 5.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(8, 31).m_171488_(-1.5f, -1.0f, -3.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(-5, 35).m_171488_(-3.0f, 0.0f, -5.0f, 6.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.4328f, (float)1.4438f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(0.0f, 0.0f, -0.5f, 4.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-1.5f, (float)0.0f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171480_().m_171488_(-4.0f, 0.0f, -0.5f, 4.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-1.5f, (float)0.0f));
        PartDefinition RightFrontLeg = Body.m_171599_("RightFrontLeg", CubeListBuilder.m_171558_().m_171514_(22, 10).m_171488_(0.0f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-0.5f, (float)-1.0f));
        PartDefinition LeftFrontLeg = Body.m_171599_("LeftFrontLeg", CubeListBuilder.m_171558_().m_171514_(22, 10).m_171480_().m_171488_(-3.0f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-0.5f, (float)-1.0f));
        PartDefinition RightBackLeg = Body.m_171599_("RightBackLeg", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(0.0f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-0.5f, (float)1.0f));
        PartDefinition LeftBackLeg = Body.m_171599_("LeftBackLeg", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171480_().m_171488_(-3.0f, -0.5f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-0.5f, (float)1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Scraplet entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ += netHeadYaw * (float)Math.PI / 180.0f;
        entity.idleAnimState.m_216974_(ageInTicks, 1.0f);
        float idleTicks = (float)entity.idleAnimState.m_216981_() / 50.0f;
        if (entity.m_20068_()) {
            this.m_267799_(ScrapletAnimation.FLY, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        } else {
            this.head.f_104203_ += headPitch * (float)Math.PI / 180.0f;
            if (entity.m_5912_()) {
                this.m_267799_(idleTicks < ScrapletAnimation.AGGRO.f_232255_() * 20.0f ? ScrapletAnimation.AGGRO : ScrapletAnimation.AGGRO_IDLE, idleTicks, 1.0f - limbSwingAmount, 1.0f, 1.0f);
                this.m_267799_(ScrapletAnimation.CHASE, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.m_233381_(entity.attackAnimState, ScrapletAnimation.ATTACK, ageInTicks);
            } else {
                this.m_267799_((float)entity.idleAnimState.m_216981_() < ScrapletAnimation.CALM.f_232255_() * 1000.0f ? ScrapletAnimation.CALM : ScrapletAnimation.IDLE, ageInTicks, 0.5f - limbSwingAmount, 1.0f, 2.0f);
                this.m_267799_(ScrapletAnimation.WALK, limbSwing, limbSwingAmount, 3.0f, 2.0f);
            }
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

