/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer;

import bnb.tfp.entity.TransformerAnimatable;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractTransformerModel<T extends LivingEntity, A extends TransformerAnimatable>
extends HierarchicalModel<T> {
    private final ModelPart root;
    protected A states;

    public AbstractTransformerModel(ModelPart root, Function<ResourceLocation, RenderType> type) {
        super(type);
        this.root = root;
    }

    public AbstractTransformerModel(ModelPart root) {
        this(root, RenderType::m_110458_);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(this.states.getTransformAnimState(), this.transformAnimation(), ageInTicks);
        this.states.getRevertAnimState().m_216979_(state -> {
            if ((double)state.m_216981_() / 1000.0 <= (double)this.revertAnimation().f_232255_()) {
                this.m_233381_((AnimationState)state, this.revertAnimation(), ageInTicks);
            } else {
                state.m_216973_();
            }
        });
    }

    public void setStates(A a) {
        this.states = a;
    }

    protected abstract AnimationDefinition transformAnimation();

    protected abstract AnimationDefinition revertAnimation();

    public boolean transformationFinished() {
        return this.states.getTransformAnimState().m_216984_() ? (double)this.states.getTransformAnimState().m_216981_() / 1000.0 > (double)this.transformAnimation().f_232255_() : !this.states.getRevertAnimState().m_216984_() || (double)this.states.getRevertAnimState().m_216981_() / 1000.0 > (double)this.revertAnimation().f_232255_();
    }

    public float transformationProgress() {
        return Mth.m_14036_((float)(this.states.getTransformAnimState().m_216984_() ? (float)this.states.getTransformAnimState().m_216981_() / 1000.0f / this.transformAnimation().f_232255_() : (this.states.getRevertAnimState().m_216984_() ? (float)this.states.getRevertAnimState().m_216981_() / 1000.0f / this.revertAnimation().f_232255_() : 1.0f)), (float)0.0f, (float)1.0f);
    }
}

