/*
 * Decompiled with CFR 0.152.
 */
package bnb.tfp.client.model.transformer.alt;

import bnb.tfp.client.model.transformer.alt.AbstractTransformerCarModel;
import bnb.tfp.transformer.HologramPlayableTransformer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractHologramTransformerCarModel<T extends HologramPlayableTransformer>
extends AbstractTransformerCarModel<AbstractClientPlayer, T> {
    protected final ModelPart hologram;
    protected final HumanoidModel<AbstractClientPlayer> hologramModel;

    public AbstractHologramTransformerCarModel(ModelPart root, ModelPart hologram, Function<ResourceLocation, RenderType> type) {
        super(root, type);
        this.hologram = hologram;
        this.hologramModel = new HumanoidModel(hologram);
        this.hologramModel.f_102610_ = false;
    }

    public AbstractHologramTransformerCarModel(ModelPart root, ModelPart hologram) {
        this(root, hologram, RenderType::m_110458_);
    }

    public void prepareMobModel(AbstractClientPlayer entity, float $$1, float $$2, float $$3) {
        super.m_6839_((Entity)entity, $$1, $$2, $$3);
        this.hologram.f_104207_ = !entity.m_20160_();
    }

    @Override
    public void setupAnim(AbstractClientPlayer entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.m_233381_(((HologramPlayableTransformer)this.states).getHologramAnimState(), this.hologramAnimation(), ageInTicks);
        this.m_233381_(((HologramPlayableTransformer)this.states).getHologramFaintAnimState(), this.hologramFaintAnimation(), ageInTicks);
        ModelPart head = this.getHologramHead();
        float yRot = netHeadYaw * (float)Math.PI / 180.0f;
        float xRot = headPitch * (float)Math.PI / 180.0f;
        float xRotFinal = Mth.m_14036_((float)xRot, (float)this.getMinClamp(), (float)this.getMaxClamp());
        float headRot = ((HologramPlayableTransformer)this.states).getTransformAnimState().m_216984_() ? 1.0f - this.transformationProgress() : this.transformationProgress();
        head.f_104203_ = Mth.m_14189_((float)headRot, (float)xRotFinal, (float)head.f_104203_);
        head.f_104204_ = Mth.m_14189_((float)headRot, (float)yRot, (float)head.f_104204_);
    }

    public void copyPropertiesToRiderModel(PlayerModel<AbstractClientPlayer> model) {
        this.hologramModel.m_102872_(model);
        model.f_102810_.f_104201_ -= 12.0f;
        model.f_102813_.f_104201_ -= 1.0f;
        model.f_102814_.f_104201_ -= 1.0f;
        model.f_102809_.m_104315_(model.f_102808_);
        model.f_103378_.m_104315_(model.f_102810_);
        model.f_103375_.m_104315_(model.f_102811_);
        model.f_103374_.m_104315_(model.f_102812_);
        model.f_103377_.m_104315_(model.f_102813_);
        model.f_103376_.m_104315_(model.f_102814_);
    }

    public abstract void translateToSeat(PoseStack var1);

    protected abstract AnimationDefinition hologramAnimation();

    protected abstract AnimationDefinition hologramFaintAnimation();

    public abstract ModelPart getHologramHead();

    public abstract float getMinClamp();

    public abstract float getMaxClamp();
}

